/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.storage;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.nullved.pmweatherapi.client.data.IClientStorage;
import net.nullved.pmweatherapi.network.PMWNetworking;
import net.nullved.pmweatherapi.network.S2CStoragePacket;
import net.nullved.pmweatherapi.storage.IStorage;
import net.nullved.pmweatherapi.storage.data.IStorageData;

public interface IServerStorage<D extends IStorageData>
extends IStorage<D> {
    public ServerLevel getLevel();

    public S2CStoragePacket<? extends IClientStorage<D>> packet(CompoundTag var1);

    default public void syncAllToAll() {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "overwrite");
        tag.putBoolean("list", true);
        ListTag list = new ListTag();
        this.getAll().forEach(data -> list.add((Object)data.serializeToNBT()));
        tag.put("data", (Tag)list);
        PMWNetworking.serverSendStorageToAll(tag, this::packet);
    }

    default public void syncAllToPlayer(Player player) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "overwrite");
        tag.putBoolean("list", true);
        ListTag list = new ListTag();
        this.getAll().forEach(data -> list.add((Object)data.serializeToNBT()));
        tag.put("data", (Tag)list);
        PMWNetworking.serverSendStorageToPlayer(tag, this::packet, player);
    }

    default public void syncAdd(D data) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "add");
        tag.put("data", (Tag)data.serializeToNBT());
        PMWNetworking.serverSendStorageToAll(tag, this::packet);
    }

    default public void syncAdd(Collection<D> datum) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "add");
        tag.putBoolean("list", true);
        ListTag list = new ListTag();
        datum.forEach(data -> list.add((Object)data.serializeToNBT()));
        tag.put("data", (Tag)list);
        PMWNetworking.serverSendStorageToAll(tag, this::packet);
    }

    default public void syncRemove(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "remove");
        tag.putString("format", "blockpos");
        tag.put("data", NbtUtils.writeBlockPos((BlockPos)pos));
        PMWNetworking.serverSendStorageToAll(tag, this::packet);
    }

    default public void syncRemoveByPos(Collection<BlockPos> posList) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "remove");
        tag.putString("format", "blockpos");
        tag.putBoolean("list", true);
        ListTag list = new ListTag();
        posList.forEach(pos -> list.remove((Object)NbtUtils.writeBlockPos((BlockPos)pos)));
        tag.put("data", (Tag)list);
        PMWNetworking.serverSendStorageToAll(tag, this::packet);
    }

    default public void syncRemove(D data) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "remove");
        tag.put("data", (Tag)data.serializeToNBT());
        PMWNetworking.serverSendStorageToAll(tag, this::packet);
    }

    default public void syncRemoveByData(Collection<D> datum) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "remove");
        tag.putBoolean("list", true);
        ListTag list = new ListTag();
        datum.forEach(data -> list.remove((Object)data.serializeToNBT()));
        tag.put("data", (Tag)list);
        PMWNetworking.serverSendStorageToAll(tag, this::packet);
    }
}

