/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.data.PMWStorageSavedData;
import net.nullved.pmweatherapi.storage.IStorage;
import net.nullved.pmweatherapi.storage.data.IStorageData;
import net.nullved.pmweatherapi.storage.data.StorageData;

public abstract class PMWStorage<D extends StorageData>
implements IStorage<D> {
    private final Map<ChunkPos, Set<D>> data = new HashMap<ChunkPos, Set<D>>();
    private final Map<ChunkPos, Long> checkTimes = new HashMap<ChunkPos, Long>();
    private final ResourceKey<Level> dimension;

    @Override
    public void clean() {
        this.data.clear();
        this.checkTimes.clear();
    }

    public abstract ResourceLocation getExpectedDataType();

    @Override
    public abstract Level getLevel();

    @Override
    public abstract ResourceLocation getId();

    @Override
    public abstract int version();

    public PMWStorage(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    @Override
    public Set<D> getAll() {
        return this.data.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<D> getAllWithinRange(BlockPos base, double radius) {
        int chunks = (int)Math.ceil(radius / 16.0) + 1;
        ChunkPos cpos = new ChunkPos(base);
        HashSet<StorageData> set = new HashSet<StorageData>();
        for (int x = -chunks; x <= chunks; ++x) {
            for (int z = -chunks; z <= chunks; ++z) {
                for (StorageData candidate : this.getInChunk(new ChunkPos(cpos.x + x, cpos.z + z))) {
                    if (!(Math.abs(base.distToCenterSqr((double)candidate.getPos().getX(), (double)candidate.getPos().getY(), (double)candidate.getPos().getZ())) <= radius * radius)) continue;
                    set.add(candidate);
                }
            }
        }
        return set;
    }

    @Override
    public Set<D> getInChunk(ChunkPos pos) {
        return this.data.getOrDefault(pos, Set.of());
    }

    @Override
    public Set<D> getInAdjacentChunks(ChunkPos pos) {
        HashSet<D> set = new HashSet<D>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                set.addAll(this.getInChunk(new ChunkPos(pos.x + x, pos.z + z)));
            }
        }
        return set;
    }

    @Override
    public boolean shouldRecalculate(ChunkPos pos) {
        if (!this.checkTimes.containsKey(pos)) {
            this.checkTimes.put(pos, System.currentTimeMillis());
            return true;
        }
        return this.checkTimes.get(pos) - System.currentTimeMillis() > 30000L;
    }

    @Override
    public void add(D addData) {
        ChunkPos chunkPos = new ChunkPos(((StorageData)addData).getPos());
        Set set = this.data.computeIfAbsent(chunkPos, c -> new HashSet());
        Set<BlockPos> exist = set.stream().map(IStorageData::getPos).filter(c -> c.equals((Object)addData.getPos())).collect(Collectors.toSet());
        if (!exist.isEmpty()) {
            this.removeByPos(exist);
        }
        set.add(addData);
        this.data.put(chunkPos, set);
    }

    @Override
    public void add(Collection<D> datum) {
        datum.forEach(this::add);
    }

    @Override
    public void remove(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Set set = this.data.computeIfAbsent(chunkPos, c -> new HashSet());
        Set<StorageData> exist = set.stream().filter(c -> c.getPos().equals((Object)pos)).collect(Collectors.toSet());
        if (!exist.isEmpty()) {
            exist.forEach(set::remove);
        }
        this.data.put(chunkPos, set);
    }

    @Override
    public void removeByPos(Collection<BlockPos> pos) {
        pos.forEach(this::remove);
    }

    @Override
    public void remove(D removedData) {
        ChunkPos chunkPos = new ChunkPos(((StorageData)removedData).getPos());
        Set set = this.data.computeIfAbsent(chunkPos, c -> new HashSet());
        set.remove(removedData);
        this.data.put(chunkPos, set);
    }

    @Override
    public void removeByData(Collection<D> datum) {
        datum.forEach(this::remove);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        PMWeatherAPI.LOGGER.info("Saving storage {} to level...", (Object)this.getId());
        if (this.version() != -1) {
            tag.putInt("version", this.version());
        }
        tag.putLong("saveTime", System.currentTimeMillis());
        ResourceLocation[] type = new ResourceLocation[]{null};
        for (Map.Entry<ChunkPos, Set<D>> entry : this.data.entrySet()) {
            ListTag list = new ListTag();
            entry.getValue().forEach(storageData -> {
                CompoundTag ctag = storageData.serializeToNBT();
                if (type[0] == null) {
                    type[0] = ResourceLocation.parse((String)ctag.getString("type"));
                }
                ctag.remove("type");
                list.add((Object)ctag);
            });
            tag.put(String.valueOf(entry.getKey().toLong()), (Tag)list);
        }
        if (type[0] != null) {
            tag.putString("type", type[0].toString());
        }
        PMWeatherAPI.LOGGER.info("Saved storage {} to level", (Object)this.getId());
        return tag;
    }

    @Override
    public void read() {
        PMWStorageSavedData savedData = (PMWStorageSavedData)((ServerLevel)this.getLevel()).getDataStorage().computeIfAbsent(PMWStorageSavedData.factory(), this.getId().toString().replace(":", "_"));
        savedData.setStorage(this);
        PMWeatherAPI.LOGGER.info("Reading storage {} from level...", (Object)this.getId());
        CompoundTag data = savedData.getTag();
        String type = this.getExpectedDataType().toString();
        int version = data.getInt("version");
        Set chunks = data.getAllKeys();
        chunks.removeAll(Set.of("version", "saveTime", "type"));
        for (String chunk : chunks) {
            HashSet<StorageData> blocks = new HashSet<StorageData>();
            ListTag list = (ListTag)data.get(chunk);
            for (int i = 0; i < list.size(); ++i) {
                try {
                    CompoundTag ctag;
                    if (!list.get(i).getType().equals((Object)CompoundTag.TYPE)) {
                        ctag = new CompoundTag();
                        ctag.put("blockpos", list.get(i));
                        if (NbtUtils.readBlockPos((CompoundTag)ctag, (String)"blockpos").isPresent()) {
                            blocks.add((StorageData)StorageData.deserializeFromNBT(ctag, version));
                            continue;
                        }
                        PMWeatherAPI.LOGGER.error("Could not deserialize tag {}! No type data and not a blockpos!", (Object)NbtUtils.toPrettyComponent((Tag)ctag.get("blockpos")));
                        continue;
                    }
                    ctag = list.getCompound(i);
                    if (!type.isEmpty()) {
                        ctag.putString("type", type);
                    }
                    blocks.add((StorageData)StorageData.deserializeFromNBT(ctag, version));
                    continue;
                }
                catch (ClassCastException e) {
                    PMWeatherAPI.LOGGER.warn("Invalid data entry in storage {} at chunk {}: {}", new Object[]{this.getId(), chunk, e.getMessage()});
                }
            }
            this.data.put(new ChunkPos(Long.parseLong(chunk)), blocks);
        }
    }
}

