/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.storage.data;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.storage.data.IStorageData;
import net.nullved.pmweatherapi.storage.data.StorageDataManager;

public abstract class StorageData
implements IStorageData {
    protected final BlockPos pos;

    public StorageData(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public CompoundTag serializeToNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", this.getId().toString());
        tag.put("blockpos", NbtUtils.writeBlockPos((BlockPos)this.pos));
        return tag;
    }

    public static BlockPos deserializeBlockPos(CompoundTag tag) {
        Optional bp = NbtUtils.readBlockPos((CompoundTag)tag, (String)"blockpos");
        if (bp.isPresent()) {
            return (BlockPos)bp.get();
        }
        PMWeatherAPI.LOGGER.warn("Could not deserialize BlockPos! Tag: {}", (Object)NbtUtils.toPrettyComponent((Tag)tag));
        return null;
    }

    public static <D extends IStorageData> D deserializeFromNBT(CompoundTag tag, int version) {
        return StorageDataManager.get(tag, version);
    }
}

