/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.event;

import com.mojang.brigadier.CommandDispatcher;
import dev.protomanly.pmweather.block.RadarBlock;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.command.NearbyRadarsCommand;
import net.nullved.pmweatherapi.data.PMWStorages;
import net.nullved.pmweatherapi.radar.RadarServerStorage;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="pmweatherapi")
public class PMWEvents {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PMWStorages.getRadar(event.getEntity().level()).syncAllToPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void onChunkLoadEvent(ChunkWatchEvent.Sent event) {
        RadarServerStorage radarStorage = PMWStorages.getRadar((Level)event.getLevel());
        if (radarStorage.shouldRecalculate(event.getChunk().getPos())) {
            ArrayList<BlockPos> radars = new ArrayList<BlockPos>();
            ServerLevel level = event.getLevel();
            Set blockEntities = event.getChunk().getBlockEntitiesPos();
            for (BlockPos pos : blockEntities) {
                if (!(level.getBlockState(pos).getBlock() instanceof RadarBlock)) continue;
                radars.add(pos);
            }
            radarStorage.addRadars(radars);
            radarStorage.syncAdd(radars);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        PMWeatherAPI.LOGGER.info("Registering PMWeatherAPI Commands");
        NearbyRadarsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onLevelLoadEvent(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            ResourceKey dimension = slevel.dimension();
            RadarServerStorage radars = new RadarServerStorage(slevel);
            radars.read();
            PMWStorages.RADARS.put((ResourceKey<Level>)dimension, radars);
            PMWeatherAPI.LOGGER.info("Loaded radars for dimension {}", (Object)slevel.dimension().location());
        }
    }

    @SubscribeEvent
    public static void onLevelUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            PMWStorages.RADARS.remove(slevel.dimension());
        }
    }
}

