/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.network;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.client.data.PMWClientStorages;
import net.nullved.pmweatherapi.client.radar.RadarClientStorage;

public record S2CRadarsPacket(CompoundTag tag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<S2CRadarsPacket> TYPE = new CustomPacketPayload.Type(PMWeatherAPI.rl("s2c_radars"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CRadarsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, S2CRadarsPacket::tag, S2CRadarsPacket::new);

    public S2CRadarsPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.tag);
    }

    public void handle(Player player) {
        try {
            String operation = this.tag.getString("operation");
            RadarClientStorage radarStorage = PMWClientStorages.getRadars();
            if (operation.equals("add")) {
                radarStorage.syncAdd(this.tag);
            } else if (operation.equals("remove")) {
                radarStorage.syncRemove(this.tag);
            } else {
                PMWeatherAPI.LOGGER.error("Unknown S2CRadarsPacket operation: {}", (Object)operation);
            }
        }
        catch (Exception e) {
            PMWeatherAPI.LOGGER.error("An error occurred when trying to write packet", (Throwable)e);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

