/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.storm;

import dev.protomanly.pmweather.event.GameBusClientEvents;
import dev.protomanly.pmweather.event.GameBusEvents;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.nullved.pmweatherapi.util.StormType;

public class NearbyStorms {
    private static final HashMap<ResourceKey<Level>, NearbyStorms> DIMENSION_MAP = new HashMap();
    private final WeatherHandler handler;

    private NearbyStorms(WeatherHandler handler) {
        this.handler = handler;
    }

    public static NearbyStorms client() {
        return new NearbyStorms((WeatherHandler)GameBusClientEvents.getClientWeather());
    }

    public static NearbyStorms get(ResourceKey<Level> dim) {
        return DIMENSION_MAP.computeIfAbsent(dim, d -> new NearbyStorms((WeatherHandler)GameBusEvents.MANAGERS.get(d)));
    }

    public static NearbyStorms get(Level level) {
        return NearbyStorms.get((ResourceKey<Level>)level.dimension());
    }

    public List<Storm> stormsNearBlock(BlockPos block, double radius) {
        List allStorms = this.handler.getStorms();
        ArrayList<Storm> nearStorms = new ArrayList<Storm>();
        for (Storm storm : allStorms) {
            Vec3 pos = storm.position;
            if (!(pos.distanceTo(block.getCenter()) <= radius)) continue;
            nearStorms.add(storm);
        }
        return nearStorms;
    }

    public List<Storm> stormsNearChunk(ChunkPos chunk, double radius) {
        List allStorms = this.handler.getStorms();
        ArrayList<Storm> nearStorms = new ArrayList<Storm>();
        for (Storm storm : allStorms) {
            Vec3 pos = storm.position;
            if (!(pos.distanceTo(chunk.getWorldPosition().getCenter()) <= radius)) continue;
            nearStorms.add(storm);
        }
        return nearStorms;
    }

    public List<Storm> stormsNearPlayer(Player player, double radius) {
        List allStorms = this.handler.getStorms();
        ArrayList<Storm> nearStorms = new ArrayList<Storm>();
        for (Storm storm : allStorms) {
            Vec3 pos = storm.position;
            if (!(pos.distanceTo(player.position()) <= radius)) continue;
            nearStorms.add(storm);
        }
        return nearStorms;
    }

    public void forStormNearBlock(BlockPos block, double radius, Consumer<Storm> consumer) {
        List<Storm> storms = this.stormsNearBlock(block, radius);
        for (Storm storm : storms) {
            consumer.accept(storm);
        }
    }

    public void forStormNearChunk(ChunkPos chunk, double radius, Consumer<Storm> consumer) {
        List<Storm> storms = this.stormsNearChunk(chunk, radius);
        for (Storm storm : storms) {
            consumer.accept(storm);
        }
    }

    public void forStormNearPlayer(Player player, double radius, Consumer<Storm> consumer) {
        List<Storm> storms = this.stormsNearPlayer(player, radius);
        for (Storm storm : storms) {
            consumer.accept(storm);
        }
    }

    public List<Storm> stormsNearBlock(BlockPos block, double radius, StormType type) {
        List allStorms = this.handler.getStorms();
        ArrayList<Storm> nearStorms = new ArrayList<Storm>();
        for (Storm storm : allStorms) {
            Vec3 pos = storm.position;
            if (!(pos.distanceTo(block.getCenter()) <= radius) || !type.matches(storm)) continue;
            nearStorms.add(storm);
        }
        return nearStorms;
    }

    public List<Storm> stormsNearChunk(ChunkPos chunk, double radius, StormType type) {
        List allStorms = this.handler.getStorms();
        ArrayList<Storm> nearStorms = new ArrayList<Storm>();
        for (Storm storm : allStorms) {
            Vec3 pos = storm.position;
            if (!(pos.distanceTo(chunk.getWorldPosition().getCenter()) <= radius) || !type.matches(storm)) continue;
            nearStorms.add(storm);
        }
        return nearStorms;
    }

    public List<Storm> stormsNearPlayer(Player player, double radius, StormType type) {
        List allStorms = this.handler.getStorms();
        ArrayList<Storm> nearStorms = new ArrayList<Storm>();
        for (Storm storm : allStorms) {
            Vec3 pos = storm.position;
            if (!(pos.distanceTo(player.position()) <= radius) || !type.matches(storm)) continue;
            nearStorms.add(storm);
        }
        return nearStorms;
    }

    public void forStormNearBlock(BlockPos block, double radius, StormType type, Consumer<Storm> consumer) {
        List<Storm> storms = this.stormsNearBlock(block, radius, type);
        for (Storm storm : storms) {
            consumer.accept(storm);
        }
    }

    public void forStormNearChunk(ChunkPos chunk, double radius, StormType type, Consumer<Storm> consumer) {
        List<Storm> storms = this.stormsNearChunk(chunk, radius, type);
        for (Storm storm : storms) {
            consumer.accept(storm);
        }
    }

    public void forStormNearPlayer(Player player, double radius, StormType type, Consumer<Storm> consumer) {
        List<Storm> storms = this.stormsNearPlayer(player, radius, type);
        for (Storm storm : storms) {
            consumer.accept(storm);
        }
    }
}

