/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.storm;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.event.GameBusEvents;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WeatherHandlerServer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.nullved.pmweatherapi.util.StormType;

public class StormBuilder {
    private final WeatherHandler weatherHandler;
    private final StormType type;
    private final Vec3 position;
    private float risk = 0.5f;
    private float rankineFactor = 4.5f;
    private float width = 15.0f;
    private float smoothWidth = 15.0f;
    private float cycloneWindspeed = 0.0f;
    private float smoothWindspeed = 0.0f;
    private int windspeed = 0;
    private int maxWindspeed = 0;
    private int stage = 0;
    private int maxStage = 2;
    private int energy = 0;
    private int coldEnergy = 0;
    private int maxColdEnergy = 300;
    private int maxWidth = 15;
    private Vec3 velocity = Vec3.ZERO;
    private boolean visualOnly = false;
    private boolean aimAtAnyPlayer = false;
    private Player aimAtPlayer;

    public StormBuilder(WeatherHandler weatherHandler, StormType type, Vec3 position) {
        this.weatherHandler = weatherHandler;
        this.type = type;
        this.position = position;
    }

    public StormBuilder(Level level, StormType type, Vec3 position) {
        this((WeatherHandler)GameBusEvents.MANAGERS.get(level.dimension()), type, position);
    }

    public StormBuilder(ResourceKey<Level> dimension, StormType type, Vec3 position) {
        this((WeatherHandler)GameBusEvents.MANAGERS.get(dimension), type, position);
    }

    public static StormBuilder atPlayer(StormType type, Player player) {
        return new StormBuilder(player.level(), type, player.position());
    }

    public StormBuilder aimAtPlayer(Player player) {
        this.aimAtPlayer = player;
        return this;
    }

    public StormBuilder aimAtAnyPlayer() {
        this.aimAtAnyPlayer = true;
        return this;
    }

    public StormBuilder visualOnly(boolean visualOnly) {
        this.visualOnly = visualOnly;
        return this;
    }

    public StormBuilder risk(float risk) {
        this.risk = risk;
        return this;
    }

    public StormBuilder rankineFactor(float rankineFactor) {
        this.rankineFactor = rankineFactor;
        return this;
    }

    public StormBuilder width(float width) {
        this.width = width;
        return this;
    }

    public StormBuilder smoothWidth(float smoothWidth) {
        this.smoothWidth = smoothWidth;
        return this;
    }

    public StormBuilder maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public StormBuilder stage(int stage) {
        this.stage = stage;
        return this;
    }

    public StormBuilder maxStage(int maxStage) {
        this.maxStage = maxStage;
        return this;
    }

    public StormBuilder energy(int energy) {
        this.energy = energy;
        return this;
    }

    public StormBuilder coldEnergy(int coldEnergy) {
        this.coldEnergy = coldEnergy;
        return this;
    }

    public StormBuilder maxColdEnergy(int maxColdEnergy) {
        this.maxColdEnergy = maxColdEnergy;
        return this;
    }

    public StormBuilder windspeed(int windspeed) {
        this.windspeed = windspeed;
        return this;
    }

    public StormBuilder cycloneWindspeed(float cycloneWindspeed) {
        this.cycloneWindspeed = cycloneWindspeed;
        return this;
    }

    public StormBuilder smoothWindspeed(float smoothWindspeed) {
        this.smoothWindspeed = smoothWindspeed;
        return this;
    }

    public StormBuilder maxWindspeed(int maxWindspeed) {
        this.maxWindspeed = maxWindspeed;
        return this;
    }

    public StormBuilder velocity(Vec3 velocity) {
        this.velocity = velocity;
        return this;
    }

    public Storm build() {
        Player nearest;
        Storm storm = new Storm(this.weatherHandler, this.weatherHandler.getWorld(), Float.valueOf(this.risk), this.type.idx());
        storm.initFirstTime();
        storm.visualOnly = this.visualOnly;
        storm.velocity = this.velocity;
        if (this.aimAtPlayer != null && storm.stormType != StormType.SQUALL.idx()) {
            Vec3 aimPos = this.aimAtPlayer.position().add(new Vec3((double)(PMWeather.RANDOM.nextFloat() - 0.5f) * ServerConfig.aimAtPlayerOffset, 0.0, (double)(PMWeather.RANDOM.nextFloat() - 0.5f) * ServerConfig.aimAtPlayerOffset));
            if (storm.position.distanceTo(aimPos) >= ServerConfig.aimAtPlayerOffset) {
                Vec3 toward = storm.position.subtract(new Vec3(aimPos.x, storm.position.y, aimPos.z)).multiply(1.0, 0.0, 1.0).normalize();
                double speed = PMWeather.RANDOM.nextDouble() * 5.0 + 1.0;
                storm.velocity = toward.multiply(-speed, 0.0, -speed);
            }
            storm.aimedAtPlayer = true;
        }
        if (this.aimAtAnyPlayer && storm.stormType != StormType.SQUALL.idx() && (nearest = storm.level.getNearestPlayer(this.position.x, this.position.y, this.position.z, 4096.0, false)) != null) {
            Vec3 aimPos = this.aimAtPlayer.position().add(new Vec3((double)(PMWeather.RANDOM.nextFloat() - 0.5f) * ServerConfig.aimAtPlayerOffset, 0.0, (double)(PMWeather.RANDOM.nextFloat() - 0.5f) * ServerConfig.aimAtPlayerOffset));
            if (storm.position.distanceTo(aimPos) >= ServerConfig.aimAtPlayerOffset) {
                Vec3 toward = storm.position.subtract(new Vec3(aimPos.x, storm.position.y, aimPos.z)).multiply(1.0, 0.0, 1.0).normalize();
                double speed = PMWeather.RANDOM.nextDouble() * 5.0 + 1.0;
                storm.velocity = toward.multiply(-speed, 0.0, -speed);
            }
            storm.aimedAtPlayer = true;
        }
        storm.position = this.position;
        storm.stage = Math.max(this.stage, this.type.stage());
        storm.maxStage = this.maxStage;
        storm.energy = this.energy;
        storm.width = this.width;
        storm.smoothWidth = this.smoothWidth;
        storm.maxWidth = this.maxWidth;
        storm.rankineFactor = this.rankineFactor;
        storm.coldEnergy = this.coldEnergy;
        storm.maxColdEnergy = this.maxColdEnergy;
        storm.windspeed = this.windspeed;
        storm.cycloneWindspeed = this.cycloneWindspeed;
        storm.smoothWindspeed = this.smoothWindspeed;
        storm.maxWindspeed = this.maxWindspeed;
        return storm;
    }

    public Storm buildAndSpawn() {
        Storm storm = this.build();
        this.weatherHandler.addStorm(storm);
        WeatherHandler weatherHandler = this.weatherHandler;
        if (weatherHandler instanceof WeatherHandlerServer) {
            WeatherHandlerServer whs = (WeatherHandlerServer)weatherHandler;
            whs.syncStormNew(storm);
        }
        return storm;
    }
}

