/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.Property;
import net.nullved.pmweatherapi.util.StringValue;

public class StringProperty
extends Property<StringValue> {
    private final ImmutableSet<StringValue> values;
    private final Map<String, StringValue> names = Maps.newHashMap();

    public StringProperty(String name, Collection<StringValue> values) {
        super(name, StringValue.class);
        this.values = ImmutableSet.copyOf(values);
        for (StringValue t : values) {
            String s = t.getSerializedName();
            if (this.names.containsKey(s)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + s + "'");
            }
            this.names.put(s, t);
        }
    }

    public Collection<StringValue> getPossibleValues() {
        return this.values;
    }

    public Optional<StringValue> getValue(String value) {
        return Optional.ofNullable(this.names.get(value));
    }

    public String getName(StringValue value) {
        return value.getSerializedName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof StringProperty) {
            StringProperty otherSP = (StringProperty)((Object)other);
            if (super.equals(other)) {
                return this.values.equals(otherSP.values) && this.names.equals(otherSP.names);
            }
        }
        return false;
    }

    public int generateHashCode() {
        int i = super.generateHashCode();
        i = 31 * i + this.values.hashCode();
        return 31 * i + this.names.hashCode();
    }

    public static StringProperty create(String name, StringValue ... values) {
        return StringProperty.create(name, Lists.newArrayList((Object[])values));
    }

    public static StringProperty create(String name, Collection<StringValue> values) {
        return new StringProperty(name, values);
    }
}

