/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Supplier;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.client.render.IRadarOverlay;
import net.nullved.pmweatherapi.client.render.RenderData;

public class RadarOverlays {
    private static final HashMap<Supplier<? extends IRadarOverlay>, Supplier<? extends Object[]>> OVERLAYS = new HashMap();

    public static Set<Supplier<? extends IRadarOverlay>> getOverlays() {
        return OVERLAYS.keySet();
    }

    public static void renderOverlays(RenderData renderData, BufferBuilder bufferBuilder, boolean canRender) {
        OVERLAYS.forEach((overlay, args) -> {
            renderData.poseStack().pushPose();
            ((IRadarOverlay)overlay.get()).render(canRender, renderData, bufferBuilder, args);
            renderData.poseStack().popPose();
        });
    }

    public static void registerOverlay(Supplier<? extends IRadarOverlay> overlay, Supplier<? extends Object[]> argsSupplier) {
        PMWeatherAPI.LOGGER.info("Registering overlay {}", (Object)overlay.get().getID());
        OVERLAYS.put(overlay, argsSupplier);
    }

    public static void registerOverlay(Supplier<? extends IRadarOverlay> overlay) {
        RadarOverlays.registerOverlay(overlay, () -> new Object[0]);
    }
}

