/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.radar.NearbyRadars;
import net.nullved.pmweatherapi.util.PMWUtils;

public class NearbyRadarsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nearbyradars").then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2048)).executes(NearbyRadarsCommand::nearbyRadars))).executes(NearbyRadarsCommand::nearbyRadars));
    }

    private static int nearbyRadars(CommandContext<CommandSourceStack> ctx) {
        int radius;
        PMWeatherAPI.LOGGER.info("Checking for nearby radars...");
        if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.pmweatherapi.non_player"));
            return 1;
        }
        ServerPlayer plr = ((CommandSourceStack)ctx.getSource()).getPlayer();
        try {
            radius = (Integer)ctx.getArgument("radius", Integer.class);
        }
        catch (Exception e) {
            radius = 512;
        }
        long startTimeMillis = System.currentTimeMillis();
        Set<BlockPos> blocks = NearbyRadars.get(plr.level()).radarsNearBlock(plr.blockPosition(), radius);
        long elapsedTime = System.currentTimeMillis() - startTimeMillis;
        StringBuilder sb = new StringBuilder("Found ").append(blocks.size()).append(" radars in ").append((float)elapsedTime / 1000.0f).append("s");
        for (BlockPos blockPos : blocks) {
            sb.append("\nPos: ").append(blockPos.toShortString());
        }
        if (PMWUtils.isRadarAdjacent(plr.level(), plr.blockPosition())) {
            sb.append("\nYou are next to a radar!");
        }
        plr.sendSystemMessage((Component)Component.literal((String)sb.toString()).withColor(ChatFormatting.GOLD.getColor().intValue()));
        return 1;
    }
}

