/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.block.RadarBlock;
import dev.protomanly.pmweather.block.entity.RadarBlockEntity;
import dev.protomanly.pmweather.config.ClientConfig;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.event.GameBusClientEvents;
import dev.protomanly.pmweather.multiblock.wsr88d.WSR88DCore;
import dev.protomanly.pmweather.render.RadarRenderer;
import dev.protomanly.pmweather.util.ColorTables;
import dev.protomanly.pmweather.util.Util;
import dev.protomanly.pmweather.weather.Clouds;
import dev.protomanly.pmweather.weather.Sounding;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.ThermodynamicEngine;
import dev.protomanly.pmweather.weather.Vorticy;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WindEngine;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nullved.pmweatherapi.client.data.PMWClientStorages;
import net.nullved.pmweatherapi.client.render.PixelRenderData;
import net.nullved.pmweatherapi.client.render.RadarOverlays;
import net.nullved.pmweatherapi.client.render.RenderData;
import net.nullved.pmweatherapi.config.PMWClientConfig;
import net.nullved.pmweatherapi.data.PMWExtras;
import net.nullved.pmweatherapi.radar.RadarMode;
import net.nullved.pmweatherapi.util.StormType;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={RadarRenderer.class})
public class RadarRendererMixin {
    @Shadow
    public static int RenderedRadars = 0;

    @WrapMethod(method={"render"})
    private void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn, Operation<Void> original) {
        if (!(blockEntity instanceof RadarBlockEntity)) {
            return;
        }
        RadarBlockEntity radarBlockEntity = (RadarBlockEntity)blockEntity;
        if (Minecraft.getInstance().player.position().distanceTo(blockEntity.getBlockPos().getCenter()) > 20.0 || RenderedRadars > 2) {
            return;
        }
        if (!((Boolean)radarBlockEntity.getBlockState().getValue((Property)RadarBlock.ON)).booleanValue()) {
            return;
        }
        ++RenderedRadars;
        boolean canRender = true;
        BlockPos pos = radarBlockEntity.getBlockPos();
        float sizeRenderDiameter = 3.0f;
        float simSize = 2048.0f;
        if (radarBlockEntity.hasRangeUpgrade) {
            simSize *= 4.0f;
            if (!ClientConfig._3X3Radar) {
                sizeRenderDiameter = 6.0f;
            }
        }
        int resolution = ClientConfig.radarResolution;
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.mul((Matrix4fc)poseStack.last().pose());
        matrix4fStack.translate(0.5f, 1.05f, 0.5f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        ArrayList storms = new ArrayList(radarBlockEntity.storms);
        boolean update = false;
        ClientConfig.RadarMode clientRadarMode = ClientConfig.radarMode;
        if (radarBlockEntity.lastUpdate < radarBlockEntity.tickCount) {
            radarBlockEntity.lastUpdate = radarBlockEntity.tickCount + 60;
            update = true;
        }
        if (ServerConfig.requireWSR88D && update) {
            canRender = false;
            int searchrange = 64;
            Level level = blockEntity.getLevel();
            if (PMWExtras.RADAR_WSR_88D_LOOKUP.containsKey(pos)) {
                BlockEntity wsr88D = level.getBlockEntity(PMWExtras.RADAR_WSR_88D_LOOKUP.get(pos));
                Block block = wsr88D.getBlockState().getBlock();
                if (block instanceof WSR88DCore) {
                    WSR88DCore wsr88DCore = (WSR88DCore)block;
                    if (wsr88DCore.isComplete(wsr88D.getBlockState())) {
                        canRender = true;
                    } else {
                        PMWExtras.RADAR_WSR_88D_LOOKUP.remove(pos);
                    }
                }
            } else {
                for (int x = -searchrange; x <= searchrange && !canRender; ++x) {
                    block15: for (int y = -searchrange; y <= searchrange && !canRender; ++y) {
                        for (int z = -searchrange * 2; z <= searchrange * 2; ++z) {
                            WSR88DCore core;
                            BlockState state = level.getBlockState(pos.offset(x, y, z));
                            Block var26 = state.getBlock();
                            if (!(var26 instanceof WSR88DCore) || !(core = (WSR88DCore)var26).isComplete(state)) continue;
                            canRender = true;
                            PMWExtras.RADAR_WSR_88D_LOOKUP.put(pos, pos.offset(x, y, z));
                            continue block15;
                        }
                    }
                }
            }
        }
        float size = sizeRenderDiameter / (float)resolution;
        RenderData renderData = new RenderData(blockEntity, sizeRenderDiameter, partialTicks, poseStack, multiBufferSource, combinedLightIn, combinedOverlayIn);
        RadarMode radarMode = (RadarMode)blockEntity.getBlockState().getValue((Property)PMWExtras.RADAR_MODE);
        if (!PMWClientStorages.RADAR_MODE_COLORS.computeIfAbsent(radarBlockEntity.getBlockPos(), bp -> new HashMap()).containsKey(radarMode)) {
            update = true;
        }
        for (int x = -resolution; x <= resolution; ++x) {
            for (int z = -resolution; z <= resolution; ++z) {
                int id = (short)x + resolution << 8 | (short)z + resolution;
                long longID = (long)(x + resolution + 1) + (long)(z + resolution + 1) * ((long)resolution * 2L + 1L);
                float dbz = radarBlockEntity.reflectivityMap.getOrDefault(longID, Float.valueOf(0.0f)).floatValue();
                float temp = radarBlockEntity.temperatureMap.getOrDefault(longID, Float.valueOf(15.0f)).floatValue();
                float vel = radarBlockEntity.velocityMap.getOrDefault(longID, Float.valueOf(0.0f)).floatValue();
                Color color = PMWClientStorages.RADAR_MODE_COLORS.computeIfAbsent(radarBlockEntity.getBlockPos(), bp -> new HashMap()).computeIfAbsent(radarMode, rm -> new HashMap()).getOrDefault(id, new Color(1.0f, 0.0f, 1.0f));
                Color dbg = radarBlockEntity.debugMap.getOrDefault(longID, new Color(0, 0, 0));
                Vector3f pixelPos = new Vector3f((float)x, 0.0f, (float)z).mul(1.0f / (float)resolution).mul(sizeRenderDiameter / 2.0f);
                Vec3 worldPos = new Vec3((double)x, 0.0, (double)z).multiply((double)(1.0f / (float)resolution), 0.0, (double)(1.0f / (float)resolution)).multiply((double)simSize, 0.0, (double)simSize).add(pos.getCenter());
                if (update) {
                    float clouds = Clouds.getCloudDensity((WeatherHandler)GameBusClientEvents.weatherHandler, (Vector2f)new Vector2f((float)worldPos.x, (float)worldPos.z), (float)0.0f);
                    dbz = 0.0f;
                    temp = 0.0f;
                    Vec2 f = new Vec2((float)x, (float)z).normalized();
                    Vec3 wind = WindEngine.getWind((Vec3)new Vec3(worldPos.x, (double)(blockEntity.getLevel().getMaxBuildHeight() + 1), worldPos.z), (Level)blockEntity.getLevel(), (boolean)false, (boolean)false, (boolean)false);
                    Vec2 w = new Vec2((float)wind.x, (float)wind.z);
                    vel = f.dot(w);
                    for (Storm storm : storms) {
                        double angle2;
                        double angle;
                        if (storm.visualOnly) continue;
                        double stormSize = ServerConfig.stormSize * 2.0;
                        if (storm.stormType == 0) {
                            stormSize *= 1.5;
                        }
                        double scale = stormSize / 1200.0;
                        if (storm.stormType == 2) {
                            scale = (float)storm.maxWidth / 3000.0f;
                            scale *= 0.5;
                        }
                        double shapeNoise = radarBlockEntity.noise.getValue((double)((float)radarBlockEntity.tickCount / 8000.0f), worldPos.x / (750.0 * scale), worldPos.z / (750.0 * scale));
                        float fineShapeNoise = RadarRenderer.FBM((SimplexNoise)radarBlockEntity.noise, (Vec3)new Vec3((double)((float)radarBlockEntity.tickCount / 8000.0f), worldPos.x / (500.0 * scale), worldPos.z / (500.0 * scale)), (int)10, (float)2.0f, (float)0.75f, (float)1.0f);
                        double shapeNoise2 = radarBlockEntity.noise.getValue((double)((float)radarBlockEntity.tickCount / 8000.0f), worldPos.z / (750.0 * scale), worldPos.x / (750.0 * scale));
                        double shapeNoise3 = radarBlockEntity.noise.getValue((double)((float)radarBlockEntity.tickCount / 16000.0f), worldPos.x / (4000.0 * scale), worldPos.z / (4000.0 * scale));
                        double shapeNoise4 = radarBlockEntity.noise.getValue((double)((float)radarBlockEntity.tickCount / 8000.0f), worldPos.z / (250.0 * scale), worldPos.x / (250.0 * scale));
                        shapeNoise *= 0.5;
                        shapeNoise2 *= 0.5;
                        shapeNoise4 *= 0.5;
                        shapeNoise += 0.5;
                        shapeNoise2 += 0.5;
                        shapeNoise4 += 0.5;
                        float localDBZ = 0.0f;
                        float smoothStage = (float)storm.stage + (float)storm.energy / 100.0f;
                        if (storm.stormType == StormType.CYCLONE.idx()) {
                            double d;
                            Vec3 wPos = worldPos;
                            Vec3 cPos = storm.position.multiply(1.0, 0.0, 1.0);
                            for (Vorticy vorticy : storm.vorticies) {
                                Vec3 vPos = vorticy.getPosition();
                                float width = vorticy.getWidth() * 0.35f;
                                d = wPos.multiply(1.0, 0.0, 1.0).distanceTo(vPos.multiply(1.0, 0.0, 1.0));
                                if (!(d < (double)width)) continue;
                                double angle3 = Math.pow(1.0 - Math.clamp(d / (double)width, 0.0, 1.0), 3.75);
                                angle3 *= 0.3141592741012573;
                                wPos = Util.rotatePoint((Vec3)wPos, (Vec3)vPos, (double)(angle3 *= (double)Math.min(vorticy.windspeedMult * (float)storm.windspeed, 6.0f)));
                            }
                            double rawDist = wPos.multiply(1.0, 0.0, 1.0).distanceTo(storm.position.multiply(1.0, 0.0, 1.0));
                            rawDist *= 1.0 + shapeNoise3 * (double)0.2f;
                            float intensity = (float)Math.pow(Math.clamp((float)storm.windspeed / 65.0f, 0.0f, 1.0f), 0.25);
                            Vec3 relPos = cPos.subtract(wPos).multiply(scale, 0.0, scale);
                            d = (float)storm.maxWidth / (3.0f + (float)storm.windspeed / 12.0f);
                            double d2 = (float)storm.maxWidth / (1.15f + (float)storm.windspeed / 12.0f);
                            double dE = (float)storm.maxWidth * 0.65f / (1.75f + (float)storm.windspeed / 12.0f);
                            double fac = 1.0 + Math.max((rawDist - (double)((float)storm.maxWidth * 0.2f)) / (double)storm.maxWidth, 0.0) * 2.0;
                            angle = Math.atan2(relPos.z, relPos.x) - rawDist / (d *= fac);
                            angle2 = Math.atan2(relPos.z, relPos.x) - rawDist / (d2 *= fac);
                            double angleE = Math.atan2(relPos.z, relPos.x) - rawDist / dE;
                            float weak = 0.0f;
                            float strong = 0.0f;
                            float intense = 0.0f;
                            float staticBands = (float)Math.sin(angle - 1.5707963267948966);
                            staticBands *= (float)Math.pow(Math.clamp(rawDist / (double)((float)storm.maxWidth * 0.25f), 0.0, 1.0), 0.1f);
                            if ((staticBands *= 1.25f * (float)Math.pow(intensity, 0.75)) < 0.0f) {
                                weak += Math.abs(staticBands);
                            } else {
                                weak += Math.abs(staticBands) * (float)Math.pow(1.0 - Math.clamp(rawDist / (double)((float)storm.maxWidth * 0.65f), 0.0, 1.0), 0.5);
                                weak *= Math.clamp(((float)storm.windspeed - 70.0f) / 40.0f, 0.0f, 1.0f);
                            }
                            float rotatingBands = (float)Math.sin((angle2 + Math.toRadians((float)storm.tickCount / 8.0f)) * 6.0);
                            rotatingBands *= (float)Math.pow(Math.clamp(rawDist / (double)((float)storm.maxWidth * 0.25f), 0.0, 1.0), 0.1f);
                            strong += Mth.lerp((float)0.45f, (float)(Math.abs(rotatingBands *= 1.25f * (float)Math.pow(intensity, 0.75)) * 0.3f + 0.7f), (float)weak);
                            intense += Mth.lerp((float)0.3f, (float)(Math.abs(rotatingBands) * 0.2f + 0.8f), (float)weak);
                            weak = (Math.abs(rotatingBands) * 0.3f + 0.6f) * weak;
                            localDBZ += Mth.lerp((float)Math.clamp(((float)storm.windspeed - 120.0f) / 60.0f, 0.0f, 1.0f), (float)Mth.lerp((float)Math.clamp(((float)storm.windspeed - 40.0f) / 90.0f, 0.0f, 1.0f), (float)weak, (float)strong), (float)intense);
                            float eye = (float)Math.sin((angleE + Math.toRadians((float)storm.tickCount / 4.0f)) * 2.0);
                            float efc = Mth.lerp((float)Math.clamp(((float)storm.windspeed - 100.0f) / 50.0f, 0.0f, 1.0f), (float)0.15f, (float)0.4f);
                            localDBZ = Math.max((float)Math.pow(1.0 - Math.clamp(rawDist / (double)((float)storm.maxWidth * efc), 0.0, 1.0), 0.5) * (Math.abs(eye * 0.1f) + 0.9f) * 1.35f * intensity, localDBZ);
                            localDBZ *= (float)Math.pow(1.0 - Math.clamp(rawDist / (double)storm.maxWidth, 0.0, 1.0), 0.5);
                            localDBZ *= Mth.lerp((float)(0.5f + Math.clamp(((float)storm.windspeed - 65.0f) / 40.0f, 0.0f, 1.0f) * 0.5f), (float)1.0f, (float)((float)Math.pow(Math.clamp(rawDist / (double)((float)storm.maxWidth * 0.1f), 0.0, 1.0), 2.0)));
                            localDBZ *= Mth.lerp((float)Math.clamp(((float)storm.windspeed - 75.0f) / 50.0f, 0.0f, 1.0f), (float)(0.8f + (float)shapeNoise2 * 0.4f), (float)1.0f);
                            localDBZ *= 0.8f + (float)shapeNoise * 0.4f;
                            localDBZ *= 1.0f + fineShapeNoise * Mth.lerp((float)((float)Math.pow(Math.clamp(rawDist / (double)storm.maxWidth, 0.0, 1.0), 1.5)), (float)0.05f, (float)0.15f);
                            localDBZ = (float)Math.pow(localDBZ, 1.75);
                            if (localDBZ > 0.8f) {
                                float dif = (localDBZ - 0.8f) / 1.25f;
                                localDBZ -= dif;
                            }
                        }
                        if (storm.stormType == StormType.SQUALL.idx()) {
                            float intensity;
                            double rawDist = worldPos.multiply(1.0, 0.0, 1.0).distanceTo(storm.position.multiply(1.0, 0.0, 1.0));
                            Vec2 v2fWorldPos = new Vec2((float)worldPos.x, (float)worldPos.z);
                            Vec2 stormVel = new Vec2((float)storm.velocity.x, (float)storm.velocity.z);
                            Vec2 v2fStormPos = new Vec2((float)storm.position.x, (float)storm.position.z);
                            Vec2 right = new Vec2(stormVel.y, -stormVel.x).normalized();
                            Vec2 fwd = stormVel.normalized();
                            Vec2 le = Util.mulVec2((Vec2)right, (float)(-3000.0f * (float)scale));
                            Vec2 ri = Util.mulVec2((Vec2)right, (float)(3000.0f * (float)scale));
                            Vec2 off = Util.mulVec2((Vec2)fwd, (float)(-((float)Math.pow(Mth.clamp((double)(rawDist / (3000.0 * scale)), (double)0.0, (double)1.0), 2.0)) * 900.0f * (float)scale));
                            le = le.add(off);
                            ri = ri.add(off);
                            le = le.add(v2fStormPos);
                            ri = ri.add(v2fStormPos);
                            float dist = Util.minimumDistance((Vec2)le, (Vec2)ri, (Vec2)v2fWorldPos);
                            switch (storm.stage) {
                                case 1: {
                                    float f2 = 0.1f + (float)storm.energy / 100.0f * 0.7f;
                                    break;
                                }
                                case 2: {
                                    float f2 = 0.8f + (float)storm.energy / 100.0f * 0.4f;
                                    break;
                                }
                                case 3: {
                                    float f2 = 1.2f + (float)storm.energy / 100.0f;
                                    break;
                                }
                                default: {
                                    float f2 = intensity = (float)storm.energy / 100.0f * 0.1f;
                                }
                            }
                            if (intensity > 0.8f) {
                                intensity = 0.8f + (intensity - 0.8f) / 1.5f;
                            }
                            Vec2 nearPoint = Util.nearestPoint((Vec2)le, (Vec2)ri, (Vec2)v2fWorldPos);
                            Vec2 facing = v2fWorldPos.add(nearPoint.negated());
                            float behind = -facing.dot(fwd);
                            behind += (float)shapeNoise * 600.0f * (float)scale * 0.2f;
                            float sze = 600.0f * (float)scale * 1.5f * 3.0f;
                            if ((behind += (float)stormSize / 2.0f) > 0.0f) {
                                float start;
                                sze *= Mth.lerp((float)Mth.clamp((float)(smoothStage - 1.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)4.0f);
                                float p = Mth.clamp((float)(Math.abs(behind) / sze), (float)0.0f, (float)1.0f);
                                if (p <= (start = 0.06f)) {
                                    localDBZ += (float)Math.pow(p /= start, 2.0);
                                } else {
                                    p = 1.0f - (p - start) / (1.0f - start);
                                    localDBZ += (float)Math.pow(p, 4.0);
                                }
                            }
                            localDBZ *= Mth.sqrt((float)(1.0f - Mth.clamp((float)(dist / sze), (float)0.0f, (float)1.0f)));
                            if (smoothStage > 3.0f) {
                                float p = Mth.clamp((float)((smoothStage - 3.0f) / 2.0f), (float)0.0f, (float)0.5f);
                                localDBZ *= 0.8f + (float)shapeNoise2 * 0.4f * (1.0f - p);
                                localDBZ *= 0.8f + (float)shapeNoise * 0.4f * (1.0f - p);
                                localDBZ *= 1.0f + p * 0.25f;
                            } else {
                                localDBZ *= 0.8f + (float)shapeNoise2 * 0.4f;
                                localDBZ *= 0.8f + (float)shapeNoise * 0.4f;
                            }
                            localDBZ *= Mth.sqrt((float)intensity);
                        }
                        if (storm.stormType == StormType.SUPERCELL.idx()) {
                            float windspeed;
                            float intensity;
                            double dist = worldPos.multiply(1.0, 0.0, 1.0).distanceTo(storm.position.multiply(1.0, 0.0, 1.0));
                            if (dist > stormSize * 4.0) continue;
                            switch (storm.stage) {
                                case 1: {
                                    float f3 = 0.1f + (float)storm.energy / 100.0f * 0.7f;
                                    break;
                                }
                                case 2: {
                                    float f3 = 0.8f + (float)storm.energy / 100.0f * 0.4f;
                                    break;
                                }
                                case 3: {
                                    float f3 = 1.2f + (float)storm.energy / 100.0f;
                                    break;
                                }
                                default: {
                                    float f3 = intensity = (float)Math.pow((float)storm.energy / 100.0f, 2.0) * 0.1f;
                                }
                            }
                            if (intensity > 0.8f) {
                                intensity = 0.8f + (intensity - 0.8f) / 4.0f;
                            }
                            switch (storm.stage) {
                                case 2: {
                                    float f4 = (float)storm.energy / 100.0f * 40.0f;
                                    break;
                                }
                                case 3: {
                                    float f4 = 40.0f + (float)storm.windspeed;
                                    break;
                                }
                                default: {
                                    float f4 = windspeed = 0.0f;
                                }
                            }
                            if (windspeed > 60.0f) {
                                windspeed -= (windspeed - 60.0f) * 0.2f;
                            }
                            Vec3 torPos = storm.position.multiply(1.0, 0.0, 1.0);
                            Vec3 corePos = torPos.add(100.0 * scale * 2.5 * (double)Math.clamp(intensity * 1.5f, 0.0f, 1.0f), 0.0, -350.0 * scale * 2.5 * (double)Math.clamp(intensity * 1.5f, 0.0f, 1.0f));
                            float xM = 1.75f;
                            if (worldPos.x > corePos.x) {
                                xM = 1.0f;
                            }
                            double coreDist = Math.sqrt(Math.pow((worldPos.x - corePos.x) * (double)xM, 2.0) + Math.pow((worldPos.z - corePos.z) * 1.5, 2.0)) / scale;
                            coreDist *= 0.9 + shapeNoise * 0.3;
                            Vec3 relPos = torPos.subtract(worldPos).multiply(scale, 0.0, scale);
                            double d = 150.0 + (dist /= scale) / 3.0;
                            double d2 = 75.0 + dist / 3.0;
                            angle = Math.atan2(relPos.z, relPos.x) - dist / d;
                            angle2 = Math.atan2(relPos.z, relPos.x) - dist / d2;
                            double angle3 = Math.atan2(relPos.z, relPos.x) - dist / d2 / 2.0;
                            angle += Math.toRadians(180.0);
                            angle2 += Math.toRadians(180.0);
                            angle3 += Math.toRadians(180.0);
                            double angleMod = Math.toRadians(40.0) * (1.0 - Math.clamp(Math.pow((double)windspeed / 100.0, 2.0), 0.0, 0.9));
                            double noise = (shapeNoise4 - 0.5) * Math.toRadians(10.0);
                            angle2 += angleMod + noise;
                            angle3 += angleMod + noise;
                            double inflow = Math.sin((angle += angleMod + noise) - Math.toRadians(15.0));
                            inflow = Math.pow(Math.abs(inflow), 0.5) * Math.sin(inflow);
                            if ((inflow *= 1.0 - Math.clamp(dist / 2400.0, 0.0, 1.0)) < 0.0) {
                                localDBZ += (float)(inflow * 2.0 * Math.pow(Math.clamp((double)(windspeed - 15.0f) / 50.0, 0.0, 1.0), 2.0));
                            }
                            double surge = Math.sin(angle2 - Math.toRadians(60.0));
                            surge = Math.abs(surge) * Math.sin(surge);
                            if ((surge *= (1.0 - Math.pow(Math.clamp(dist / 1200.0, 0.0, 1.0), 1.5)) * (1.0 - Math.clamp(dist / 200.0, 0.0, 0.3))) > 0.0) {
                                double n = 0.8 * (1.0 - Math.clamp(Math.pow((double)windspeed / 80.0, 2.0), 0.0, 1.0));
                                double m = 1.0 - shapeNoise4 * n;
                                localDBZ += (float)(surge * 1.5 * Math.clamp(dist / 500.0, 0.0, 1.0) * Math.sqrt(Math.clamp((double)(windspeed - 20.0f) / 50.0, 0.0, 1.0)) * m);
                            }
                            double shield = Math.sin(angle3 - Math.toRadians(60.0));
                            shield = Math.abs(shield) * Math.sin(shield);
                            if ((shield *= 1.0 - Math.pow(Math.clamp(dist / 2400.0, 0.0, 1.0), 2.0)) > 0.0) {
                                localDBZ -= (float)(shield * 2.0 * Math.clamp(dist / 1000.0, 0.0, 1.0) * Math.sqrt(Math.clamp((double)(windspeed - 30.0f) / 80.0, 0.0, 1.0)));
                            }
                            double coreIntensity = (1.0 - Math.clamp(coreDist / 1800.0, 0.0, 1.0)) * (1.5 - shapeNoise2 * 0.5) * Math.sqrt(Math.clamp((double)intensity / 2.0, 0.0, 1.0)) * Math.clamp(dist / 300.0, 0.5, 1.0) * 1.2;
                            localDBZ += (float)Math.pow(coreIntensity, 0.65);
                        }
                        dbz = Math.max(dbz, localDBZ);
                    }
                    float v = Math.max(clouds - 0.15f, 0.0f) * 4.0f;
                    if (v > 0.4f) {
                        float dif = (v - 0.4f) / 2.0f;
                        v -= dif;
                    }
                    dbz = Math.max(dbz, v);
                    dbz += (PMWeather.RANDOM.nextFloat() - 0.5f) * 5.0f / 60.0f;
                    vel += (PMWeather.RANDOM.nextFloat() - 0.5f) * 3.0f;
                    if (dbz > 1.0f) {
                        dbz = (dbz - 1.0f) / 3.0f + 1.0f;
                    }
                    if (!canRender) {
                        dbz = PMWeather.RANDOM.nextFloat() * 1.2f;
                        vel = (PMWeather.RANDOM.nextFloat() - 0.5f) * 300.0f;
                        temp = 15.0f;
                    } else {
                        temp = ThermodynamicEngine.samplePoint((WeatherHandler)GameBusClientEvents.weatherHandler, (Vec3)worldPos, (Level)blockEntity.getLevel(), (RadarBlockEntity)radarBlockEntity, (int)0).temperature();
                    }
                    radarBlockEntity.reflectivityMap.put(longID, Float.valueOf(dbz));
                    radarBlockEntity.temperatureMap.put(longID, Float.valueOf(temp));
                    radarBlockEntity.velocityMap.put(longID, Float.valueOf(vel));
                    if (!PMWClientConfig.disableCustomRadarModeRendering) {
                        PixelRenderData pixelRenderData = new PixelRenderData(canRender, dbz * 60.0f, vel, temp, x, z, resolution, worldPos, renderData);
                        color = radarMode.getColorForPixel(pixelRenderData);
                        ((Map)PMWClientStorages.RADAR_MODE_COLORS.computeIfAbsent(radarBlockEntity.getBlockPos(), bp -> new HashMap()).get(radarMode)).put(id, color);
                    }
                }
                float rdbz = dbz * 60.0f;
                Color startColor = radarBlockEntity.terrainMap.getOrDefault(longID, Color.BLACK);
                if (radarBlockEntity.init && update) {
                    Holder biome = radarBlockEntity.getNearestBiome(new BlockPos((int)worldPos.x, (int)worldPos.y, (int)worldPos.z));
                    String rn = biome.getRegisteredName().toLowerCase();
                    startColor = rn.contains("ocean") || rn.contains("river") ? new Color(((Biome)biome.value()).getWaterColor()) : (rn.contains("beach") || rn.contains("desert") ? new Color(227, 198, 150) : (rn.contains("badlands") ? new Color(214, 111, 42) : new Color(((Biome)biome.value()).getGrassColor(worldPos.x, worldPos.z))));
                    radarBlockEntity.terrainMap.put(longID, startColor);
                }
                if (PMWClientConfig.disableCustomRadarModeRendering) {
                    color = ColorTables.getReflectivity((float)rdbz, (Color)startColor);
                    if (rdbz > 5.0f && !radarBlockEntity.hasRangeUpgrade) {
                        if (temp < 3.0f && temp > -1.0f) {
                            color = ColorTables.getMixedReflectivity((float)rdbz);
                        } else if (temp <= -1.0f) {
                            color = ColorTables.getSnowReflectivity((float)rdbz);
                        }
                    }
                    if (radarMode == RadarMode.VELOCITY) {
                        color = new Color(0, 0, 0);
                        color = ColorTables.lerp((float)Mth.clamp((float)(Math.max(rdbz, (Mth.abs((float)(vel /= 1.75f)) - 18.0f) / 0.65f) / 12.0f), (float)0.0f, (float)1.0f), (Color)color, (Color)ColorTables.getVelocity((float)vel));
                    }
                    if (radarMode == RadarMode.IR) {
                        float ir = rdbz * 10.0f;
                        if (rdbz > 10.0f) {
                            ir = 100.0f + (rdbz - 10.0f) * 2.5f;
                        }
                        if (rdbz > 50.0f) {
                            ir += (rdbz - 50.0f) * 5.0f;
                        }
                        color = ColorTables.getIR((float)ir);
                    }
                }
                if (ClientConfig.radarDebugging && update) {
                    if (clientRadarMode == ClientConfig.RadarMode.TEMPERATURE) {
                        float t = ThermodynamicEngine.samplePoint((WeatherHandler)GameBusClientEvents.weatherHandler, (Vec3)worldPos, (Level)blockEntity.getLevel(), (RadarBlockEntity)radarBlockEntity, (int)0).temperature();
                        dbg = t <= 0.0f ? ColorTables.lerp((float)Math.clamp(t / -40.0f, 0.0f, 1.0f), (Color)new Color(153, 226, 251, 255), (Color)new Color(29, 53, 221, 255)) : (t < 15.0f ? ColorTables.lerp((float)Math.clamp(t / 15.0f, 0.0f, 1.0f), (Color)new Color(255, 255, 255, 255), (Color)new Color(225, 174, 46, 255)) : ColorTables.lerp((float)Math.clamp((t - 15.0f) / 25.0f, 0.0f, 1.0f), (Color)new Color(225, 174, 46, 255), (Color)new Color(232, 53, 14, 255)));
                    }
                    if (clientRadarMode == ClientConfig.RadarMode.SST) {
                        Float t = ThermodynamicEngine.GetSST((WeatherHandler)GameBusClientEvents.weatherHandler, (Vec3)worldPos, (Level)blockEntity.getLevel(), (RadarBlockEntity)radarBlockEntity, (int)0);
                        dbg = t == null ? new Color(0, 0, 0) : ColorTables.getSST((float)t.floatValue());
                    }
                    if (clientRadarMode == ClientConfig.RadarMode.WINDFIELDS && GameBusClientEvents.weatherHandler != null) {
                        Vec3 wP = new Vec3((double)x, 0.0, (double)z).multiply((double)(1.0f / (float)resolution), 0.0, (double)(1.0f / (float)resolution)).multiply(256.0, 0.0, 256.0).add(pos.getCenter());
                        float wind = 0.0f;
                        for (Storm storm : storms) {
                            wind += storm.getWind(wP);
                        }
                        dbg = ColorTables.getWindspeed((float)wind);
                    }
                    if (clientRadarMode == ClientConfig.RadarMode.GLOBALWINDS && GameBusClientEvents.weatherHandler != null) {
                        int height = GameBusClientEvents.weatherHandler.getWorld().getHeight(Heightmap.Types.MOTION_BLOCKING, (int)worldPos.x, (int)worldPos.z);
                        float wind = (float)WindEngine.getWind((Vec3)new Vec3(worldPos.x, (double)height, worldPos.z), (Level)GameBusClientEvents.weatherHandler.getWorld(), (boolean)false, (boolean)false, (boolean)false, (boolean)true).length();
                        dbg = ColorTables.getHurricaneWindspeed((float)wind);
                    }
                    if (clientRadarMode == ClientConfig.RadarMode.CAPE) {
                        Sounding sounding = new Sounding(GameBusClientEvents.weatherHandler, worldPos, blockEntity.getLevel(), 500, 12000, radarBlockEntity);
                        Sounding.CAPE CAPE2 = sounding.getCAPE(sounding.getSBParcel());
                        dbg = ColorTables.lerp((float)Mth.clamp((float)(CAPE2.CAPE() / 6000.0f), (float)0.0f, (float)1.0f), (Color)new Color(0, 0, 0), (Color)new Color(255, 0, 0));
                    }
                    if (clientRadarMode == ClientConfig.RadarMode.CAPE3KM) {
                        Sounding sounding = new Sounding(GameBusClientEvents.weatherHandler, worldPos, blockEntity.getLevel(), 250, 4000, radarBlockEntity);
                        Sounding.CAPE CAPE3 = sounding.getCAPE(sounding.getSBParcel());
                        dbg = ColorTables.lerp((float)Mth.clamp((float)(CAPE3.CAPE3() / 1000.0f), (float)0.0f, (float)1.0f), (Color)new Color(0, 0, 0), (Color)new Color(255, 0, 0));
                    }
                    if (clientRadarMode == ClientConfig.RadarMode.CINH) {
                        Sounding sounding = new Sounding(GameBusClientEvents.weatherHandler, worldPos, blockEntity.getLevel(), 500, 12000, radarBlockEntity);
                        Sounding.CAPE CAPE4 = sounding.getCAPE(sounding.getSBParcel());
                        dbg = ColorTables.lerp((float)Mth.clamp((float)(CAPE4.CINH() / -250.0f), (float)0.0f, (float)1.0f), (Color)new Color(0, 0, 0), (Color)new Color(0, 0, 255));
                    }
                    if (clientRadarMode == ClientConfig.RadarMode.LAPSERATE03) {
                        Sounding sounding = new Sounding(GameBusClientEvents.weatherHandler, worldPos, blockEntity.getLevel(), 250, 4000, radarBlockEntity);
                        float lapse = (float)Math.floor(sounding.getLapseRate(0, 3000).floatValue() * 2.0f) / 2.0f;
                        dbg = lapse > 5.0f ? ColorTables.lerp((float)Mth.clamp((float)((lapse - 5.0f) / 5.0f), (float)0.0f, (float)1.0f), (Color)new Color(255, 255, 0), (Color)new Color(255, 0, 0)) : ColorTables.lerp((float)Mth.clamp((float)(lapse / 5.0f), (float)0.0f, (float)1.0f), (Color)new Color(0, 255, 0), (Color)new Color(255, 255, 0));
                    }
                    if (clientRadarMode == ClientConfig.RadarMode.LAPSERATE36) {
                        Sounding sounding = new Sounding(GameBusClientEvents.weatherHandler, worldPos, blockEntity.getLevel(), 250, 7000, radarBlockEntity);
                        float lapse = (float)Math.floor(sounding.getLapseRate(3000, 6000).floatValue() * 2.0f) / 2.0f;
                        dbg = lapse > 5.0f ? ColorTables.lerp((float)Mth.clamp((float)((lapse - 5.0f) / 5.0f), (float)0.0f, (float)1.0f), (Color)new Color(255, 255, 0), (Color)new Color(255, 0, 0)) : ColorTables.lerp((float)Mth.clamp((float)(lapse / 5.0f), (float)0.0f, (float)1.0f), (Color)new Color(0, 255, 0), (Color)new Color(255, 255, 0));
                    }
                    radarBlockEntity.debugMap.put(longID, dbg);
                }
                if (ClientConfig.radarDebugging) {
                    color = dbg;
                }
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                float a = (float)color.getAlpha() / 255.0f * 0.75f + 0.25f;
                Vector3f topLeft = new Vector3f(-1.0f, 0.0f, -1.0f).mul(size / 4.0f).add((Vector3fc)pixelPos);
                Vector3f bottomLeft = new Vector3f(-1.0f, 0.0f, 1.0f).mul(size / 4.0f).add((Vector3fc)pixelPos);
                Vector3f bottomRight = new Vector3f(1.0f, 0.0f, 1.0f).mul(size / 4.0f).add((Vector3fc)pixelPos);
                Vector3f topRight = new Vector3f(1.0f, 0.0f, -1.0f).mul(size / 4.0f).add((Vector3fc)pixelPos);
                bufferBuilder.addVertex(topLeft).setColor(r, g, b, a).addVertex(bottomLeft).setColor(r, g, b, a).addVertex(bottomRight).setColor(r, g, b, a).addVertex(topRight).setColor(r, g, b, a);
            }
        }
        int color = radarMode.getDotColor().getRGB();
        Vector3f topLeft = new Vector3f(-1.0f, 0.0f, -1.0f).mul(0.015f).add(0.0f, 0.01f, 0.0f);
        Vector3f bottomLeft = new Vector3f(-1.0f, 0.0f, 1.0f).mul(0.015f).add(0.0f, 0.01f, 0.0f);
        Vector3f bottomRight = new Vector3f(1.0f, 0.0f, 1.0f).mul(0.015f).add(0.0f, 0.01f, 0.0f);
        Vector3f topRight = new Vector3f(1.0f, 0.0f, -1.0f).mul(0.015f).add(0.0f, 0.01f, 0.0f);
        bufferBuilder.addVertex(topLeft).setColor(color).addVertex(bottomLeft).setColor(color).addVertex(bottomRight).setColor(color).addVertex(topRight).setColor(color);
        RadarOverlays.renderOverlays(renderData, bufferBuilder, canRender);
        matrix4fStack.mul((Matrix4fc)poseStack.last().pose().invert());
        matrix4fStack.translate(-0.5f, -1.05f, -0.5f);
        matrix4fStack.popMatrix();
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }
}

