/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.radar;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.data.PMWSavedData;

public abstract class RadarStorage {
    private Map<ChunkPos, Set<BlockPos>> radars = new HashMap<ChunkPos, Set<BlockPos>>();
    private Map<ChunkPos, Long> checkTimes = new HashMap<ChunkPos, Long>();
    private ResourceKey<Level> dimension;

    public abstract Level getLevel();

    public RadarStorage(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public Set<BlockPos> getAllRadars() {
        return this.radars.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<BlockPos> getRadarsInChunk(ChunkPos pos) {
        return this.radars.getOrDefault(pos, Set.of());
    }

    public boolean shouldRecalculate(ChunkPos pos) {
        if (!this.checkTimes.containsKey(pos)) {
            this.checkTimes.put(pos, System.currentTimeMillis());
            return true;
        }
        return this.checkTimes.get(pos) - System.currentTimeMillis() > 30000L;
    }

    public void addRadar(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Set set = this.radars.computeIfAbsent(chunkPos, c -> new HashSet());
        set.add(pos);
        this.radars.put(chunkPos, set);
    }

    public void addRadars(Collection<BlockPos> pos) {
        pos.forEach(this::addRadar);
    }

    public void removeRadar(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Set set = this.radars.computeIfAbsent(chunkPos, c -> new HashSet());
        set.remove(pos);
        this.radars.put(chunkPos, set);
    }

    public void removeRadars(Collection<BlockPos> pos) {
        pos.forEach(this::removeRadar);
    }

    public CompoundTag save(CompoundTag tag) {
        PMWeatherAPI.LOGGER.info("Saving radars to level...");
        tag.putInt("version", 1);
        tag.putLong("saveTime", System.currentTimeMillis());
        for (Map.Entry<ChunkPos, Set<BlockPos>> entry : this.radars.entrySet()) {
            ListTag blockList = new ListTag();
            entry.getValue().forEach(blockPos -> blockList.add((Object)NbtUtils.writeBlockPos((BlockPos)blockPos)));
            tag.put(String.valueOf(entry.getKey().toLong()), (Tag)blockList);
        }
        PMWeatherAPI.LOGGER.info("Saved radars to level");
        return tag;
    }

    public void read() {
        PMWSavedData savedData = (PMWSavedData)((ServerLevel)this.getLevel()).getDataStorage().computeIfAbsent(PMWSavedData.factory(), "pmweatherapi_radars");
        savedData.setRadarStorage(this);
        PMWeatherAPI.LOGGER.info("Reading radars from level...");
        CompoundTag data = savedData.getTag();
        Set chunks = data.getAllKeys();
        chunks.removeAll(Set.of("version", "saveTime"));
        for (String chunk : chunks) {
            HashSet<BlockPos> radars = new HashSet<BlockPos>();
            ListTag blockList = (ListTag)data.get(chunk);
            for (int i = 0; i < blockList.size(); ++i) {
                int[] bp = blockList.getIntArray(i);
                radars.add(new BlockPos(bp[0], bp[1], bp[2]));
            }
            this.radars.put(new ChunkPos(Long.parseLong(chunk)), radars);
        }
    }
}

