/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;

public class ColorMap {
    private final boolean overrideModeGreater;
    private final NavigableMap<Float, LerpSegment> segments;
    private final NavigableMap<Float, Color> overridePoints;
    private final Color base;
    private final float min;
    private final float max;
    private final float firstThreshold;
    private Color[] lookup;
    private float resolution;

    private ColorMap(Color base, boolean overrideModeGreater, List<LerpSegment> segments, NavigableMap<Float, Color> overridePoints, float resolution) {
        this.min = (float)Math.round(segments.getFirst().start / resolution) * resolution;
        this.max = (float)Math.round(segments.getLast().end / resolution) * resolution;
        this.firstThreshold = segments.getFirst().end;
        this.base = base;
        this.overrideModeGreater = overrideModeGreater;
        this.segments = new TreeMap<Float, LerpSegment>();
        for (LerpSegment seg : segments) {
            this.segments.put(Float.valueOf(seg.start), seg);
        }
        this.overridePoints = overridePoints;
        this.recomputeLookups(resolution);
    }

    public float minValue() {
        return this.min;
    }

    public float maxValue() {
        return this.max;
    }

    public void recomputeLookups(float resolution) {
        this.resolution = resolution;
        int size = (int)((this.max - this.min) / resolution + 1.0f);
        this.lookup = new Color[size];
        for (int i = 0; i < size; ++i) {
            float val = this.min + (float)i * resolution;
            this.lookup[i] = this.getAccurate(val);
        }
    }

    public Color get(float val) {
        float newVal = (float)Math.round(val / this.resolution) * this.resolution;
        if (newVal <= this.min) {
            return this.lookup[0];
        }
        if (newVal >= this.max) {
            return this.lookup[this.lookup.length - 1];
        }
        int idx = (int)((newVal - this.min) / this.resolution);
        return this.lookup[idx];
    }

    public Color getWithBiome(float val, Holder<Biome> biome, Vec3 worldPos) {
        String rn = biome.getRegisteredName().toLowerCase();
        Color startColor = rn.contains("ocean") || rn.contains("river") ? new Color(((Biome)biome.value()).getWaterColor()) : (rn.contains("beach") || rn.contains("desert") ? (rn.contains("badlands") ? new Color(214, 111, 42) : new Color(((Biome)biome.value()).getGrassColor(worldPos.x, worldPos.z))) : new Color(227, 198, 150));
        if (val < this.firstThreshold) {
            return ColorMap.lerp(Math.clamp(val / (this.firstThreshold - this.min), 0.0f, 1.0f), startColor, this.segments.firstEntry().getValue().to);
        }
        return this.get(val);
    }

    public Color getAccurate(float val) {
        Map.Entry<Float, LerpSegment> entry;
        Color currentColor = this.base;
        Map.Entry<Float, Color> override = this.overridePoints.floorEntry(Float.valueOf(val));
        if (override != null) {
            currentColor = override.getValue();
        }
        if ((entry = this.segments.floorEntry(Float.valueOf(val))) != null) {
            LerpSegment seg = entry.getValue();
            if (this.overrideModeGreater ? val <= seg.end : val < seg.end) {
                float delta = (val - seg.start) / (seg.end - seg.start);
                delta = delta > 1.0f ? 1.0f : (delta < 0.0f ? 0.0f : delta);
                return ColorMap.lerp(delta, seg.from, seg.to);
            }
        }
        return currentColor;
    }

    public static Color lerp(float delta, Color c1, Color c2) {
        float r = (float)c1.getRed() + delta * (float)(c2.getRed() - c1.getRed());
        float g = (float)c1.getGreen() + delta * (float)(c2.getGreen() - c1.getGreen());
        float b = (float)c1.getBlue() + delta * (float)(c2.getBlue() - c1.getBlue());
        return new Color((int)r, (int)g, (int)b);
    }

    public record LerpSegment(float start, Color from, float end, Color to) {
    }

    public static class Builder {
        private final List<LerpSegment> segments = new ArrayList<LerpSegment>();
        private final NavigableMap<Float, Color> overridePoints = new TreeMap<Float, Color>();
        private final Color base;
        private boolean overrideModeGreater = false;
        private float lastThreshold = Float.NEGATIVE_INFINITY;
        private float resolution = 0.1f;
        private Color lastColor;

        private Builder(Color base) {
            this.base = base;
            this.lastColor = base;
        }

        public static Builder of(Color base) {
            return new Builder(base);
        }

        public static Builder biome() {
            return new Builder(Color.BLACK);
        }

        public Builder lookupResolution(float resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder overrideModeGreater() {
            this.overrideModeGreater = true;
            return this;
        }

        public Builder addPoint(Color color, float threshold) {
            if (this.lastThreshold != Float.NEGATIVE_INFINITY) {
                this.segments.add(new LerpSegment(this.lastThreshold, this.lastColor, threshold, color));
            }
            this.lastThreshold = threshold;
            this.lastColor = color;
            return this;
        }

        public Builder override(Color color, float threshold) {
            this.overridePoints.put(Float.valueOf(threshold), color);
            this.lastThreshold = threshold;
            this.lastColor = color;
            return this;
        }

        public ColorMap build(Color finalColor, float finalThreshold) {
            if (!this.segments.isEmpty()) {
                LerpSegment first = this.segments.getFirst();
                if (first.start > 0.0f) {
                    this.segments.add(0, new LerpSegment(0.0f, this.base, first.start, first.from));
                }
            }
            if (this.overrideModeGreater) {
                this.overridePoints.put(Float.valueOf(finalThreshold + 1.0E-4f), finalColor);
            } else {
                this.overridePoints.put(Float.valueOf(finalThreshold), finalColor);
            }
            this.segments.add(new LerpSegment(this.lastThreshold, this.lastColor, finalThreshold, finalColor));
            return new ColorMap(this.base, this.overrideModeGreater, this.segments, this.overridePoints, this.resolution);
        }
    }
}

