/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.radar;

import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.nullved.pmweatherapi.radar.RadarStorage;

public class RadarClientStorage
extends RadarStorage {
    public RadarClientStorage(ResourceKey<Level> dimension) {
        super(dimension);
    }

    @Override
    public Level getLevel() {
        return Minecraft.getInstance().level;
    }

    public void syncAdd(CompoundTag tag) {
        if (tag.contains("list") && tag.getBoolean("list")) {
            ListTag list = tag.getList("data", 11);
            this.addRadars(list.stream().map(t -> {
                if (t instanceof IntArrayTag) {
                    IntArrayTag iat = (IntArrayTag)t;
                    return new BlockPos(iat.get(0).getAsInt(), iat.get(1).getAsInt(), iat.get(2).getAsInt());
                }
                return null;
            }).collect(Collectors.toSet()));
        } else {
            this.addRadar((BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"data").orElseThrow());
        }
    }

    public void syncRemove(CompoundTag tag) {
        if (tag.contains("list") && tag.getBoolean("list")) {
            ListTag list = tag.getList("data", 11);
            this.removeRadars(list.stream().map(t -> {
                if (t instanceof IntArrayTag) {
                    IntArrayTag iat = (IntArrayTag)t;
                    return new BlockPos(iat.get(0).getAsInt(), iat.get(1).getAsInt(), iat.get(2).getAsInt());
                }
                return null;
            }).collect(Collectors.toSet()));
        } else {
            this.removeRadar((BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"data").orElseThrow());
        }
    }
}

