/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.nullved.pmweatherapi.client.render.RenderData;
import net.nullved.pmweatherapi.data.PMWExtras;
import net.nullved.pmweatherapi.radar.RadarMode;

public interface IRadarOverlay {
    public void render(boolean var1, RenderData var2, BufferBuilder var3, Object ... var4);

    default public RadarMode getRadarMode(RenderData renderData) {
        return (RadarMode)renderData.blockEntity().getBlockState().getValue((Property)PMWExtras.RADAR_MODE);
    }

    default public void renderText(Component component, RenderData renderData, PoseStack poseStack) {
        Font font = Minecraft.getInstance().font;
        poseStack.mulPose(Axis.XN.rotationDegrees(-90.0f));
        font.drawInBatch(component, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), renderData.multiBufferSource(), Font.DisplayMode.NORMAL, 0xFFFFFF, 0xFFFFFF);
        poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
    }

    default public void renderText(Component component, RenderData renderData) {
        this.renderText(component, renderData, renderData.poseStack());
    }

    public String getModID();

    default public String getIDPath() {
        return this.getClass().getSimpleName().replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }

    default public ResourceLocation getID() {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModID(), (String)this.getIDPath());
    }
}

