/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.radar;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.nullved.pmweatherapi.network.PMWNetworking;
import net.nullved.pmweatherapi.radar.RadarStorage;

public class RadarServerStorage
extends RadarStorage {
    private final ServerLevel level;

    public RadarServerStorage(ServerLevel level) {
        super((ResourceKey<Level>)level.dimension());
        this.level = level;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public void syncAllToPlayer(Player player) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "add");
        tag.putBoolean("list", true);
        ListTag list = new ListTag();
        for (BlockPos pos : this.getAllRadars()) {
            list.add((Object)NbtUtils.writeBlockPos((BlockPos)pos));
        }
        tag.put("data", (Tag)list);
        PMWNetworking.serverSendRadarsToPlayer(tag, player);
    }

    public void syncAdd(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "add");
        tag.put("data", NbtUtils.writeBlockPos((BlockPos)pos));
        PMWNetworking.serverSendRadarsToAll(tag);
    }

    public void syncAdd(Collection<BlockPos> posList) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "add");
        tag.putBoolean("list", true);
        ListTag list = new ListTag();
        for (BlockPos pos : posList) {
            list.add((Object)NbtUtils.writeBlockPos((BlockPos)pos));
        }
        tag.put("data", (Tag)list);
        PMWNetworking.serverSendRadarsToAll(tag);
    }

    public void syncRemove(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "remove");
        tag.put("data", NbtUtils.writeBlockPos((BlockPos)pos));
        PMWNetworking.serverSendRadarsToAll(tag);
    }

    public void syncRemove(Collection<BlockPos> posList) {
        CompoundTag tag = new CompoundTag();
        tag.putString("operation", "remove");
        tag.putBoolean("list", true);
        ListTag list = new ListTag();
        for (BlockPos pos : posList) {
            list.add((Object)NbtUtils.writeBlockPos((BlockPos)pos));
        }
        tag.put("data", (Tag)list);
        PMWNetworking.serverSendRadarsToAll(tag);
    }
}

