/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.data;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.client.radar.RadarClientStorage;
import net.nullved.pmweatherapi.radar.RadarMode;

@OnlyIn(value=Dist.CLIENT)
public class PMWClientStorages {
    public static Map<BlockPos, Map<RadarMode, Map<Integer, Color>>> RADAR_MODE_COLORS = new HashMap<BlockPos, Map<RadarMode, Map<Integer, Color>>>();
    private static Level lastLevel;
    private static RadarClientStorage radar;

    public static void resetRadars() {
        radar = null;
    }

    public static RadarClientStorage getRadars() {
        try {
            ClientLevel level = Minecraft.getInstance().level;
            if (radar == null || level != lastLevel) {
                PMWClientStorages.init((Level)level);
            }
        }
        catch (Exception e) {
            PMWeatherAPI.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return radar;
    }

    public static void init(Level level) {
        lastLevel = level;
        if (level != null) {
            radar = new RadarClientStorage((ResourceKey<Level>)level.dimension());
        }
    }
}

