/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.network;

import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.network.S2CRadarsPacket;

public class PMWNetworking {
    public static final ResourceLocation RADARS_ID = PMWeatherAPI.rl("radars");

    public static void register(Object ... args) {
        PMWNetworking.registerClientboundPacket(S2CRadarsPacket.TYPE, S2CRadarsPacket.STREAM_CODEC, S2CRadarsPacket::handle, args);
    }

    public static <T extends CustomPacketPayload> void registerServerboundPacket(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        PayloadRegistrar registrar = (PayloadRegistrar)args[0];
        IPayloadHandler serverHandler = (pkt, ctx) -> ctx.enqueueWork(() -> handler.accept(pkt, ctx.player()));
        registrar.playToServer(type, codec, serverHandler);
    }

    public static <T extends CustomPacketPayload, B extends FriendlyByteBuf> void registerClientboundPacket(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> codec, BiConsumer<T, Player> handler, Object ... args) {
        PayloadRegistrar registrar = (PayloadRegistrar)args[0];
        IPayloadHandler clientHandler = (pkt, ctx) -> ctx.enqueueWork(() -> handler.accept(pkt, ctx.player()));
        registrar.playToClient(type, codec, clientHandler);
    }

    public static void serverSendRadarsToAll(CompoundTag tag) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new S2CRadarsPacket(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void serverSendRadarsToPlayer(CompoundTag tag, Player player) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new S2CRadarsPacket(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

