/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.data;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.client.data.IClientStorage;
import net.nullved.pmweatherapi.client.metar.MetarClientStorage;
import net.nullved.pmweatherapi.client.radar.RadarClientStorage;
import net.nullved.pmweatherapi.client.radar.WSRClientStorage;
import net.nullved.pmweatherapi.client.storage.ClientStorageInstance;
import net.nullved.pmweatherapi.metar.MetarStorage;
import net.nullved.pmweatherapi.metar.MetarStorageData;
import net.nullved.pmweatherapi.radar.RadarMode;
import net.nullved.pmweatherapi.radar.storage.RadarStorage;
import net.nullved.pmweatherapi.radar.storage.RadarStorageData;
import net.nullved.pmweatherapi.radar.storage.WSRStorage;
import net.nullved.pmweatherapi.radar.storage.WSRStorageData;
import net.nullved.pmweatherapi.storage.data.StorageData;

@OnlyIn(value=Dist.CLIENT)
public class PMWClientStorages {
    public static Map<BlockPos, Map<RadarMode, Map<Integer, Color>>> RADAR_MODE_COLORS = new HashMap<BlockPos, Map<RadarMode, Map<Integer, Color>>>();
    public static final Map<ResourceLocation, ClientStorageInstance<?, ?>> STORAGE_INSTANCES = new HashMap();
    private static ClientLevel lastLevel;

    public static ClientStorageInstance<RadarStorageData, RadarClientStorage> radars() {
        return PMWClientStorages.get(RadarStorage.ID, RadarClientStorage.class).orElseThrow();
    }

    public static ClientStorageInstance<MetarStorageData, MetarClientStorage> metars() {
        return PMWClientStorages.get(MetarStorage.ID, MetarClientStorage.class).orElseThrow();
    }

    public static ClientStorageInstance<WSRStorageData, WSRClientStorage> wsrs() {
        return PMWClientStorages.get(WSRStorage.ID, WSRClientStorage.class).orElseThrow();
    }

    public static ClientStorageInstance<?, ?> get(ResourceLocation location) {
        ClientStorageInstance<?, ?> csi;
        ClientLevel curLevel;
        if (!STORAGE_INSTANCES.containsKey(location)) {
            PMWeatherAPI.LOGGER.error("No storage instance found for location {}", (Object)location);
        }
        if ((curLevel = Minecraft.getInstance().level) != null && curLevel != lastLevel) {
            PMWClientStorages.loadDimension(curLevel);
        }
        if ((csi = STORAGE_INSTANCES.get(location)).get() == null) {
            csi.load(curLevel);
        }
        return csi;
    }

    public static void set(ResourceLocation location, ClientStorageInstance<?, ?> instance) {
        STORAGE_INSTANCES.put(location, instance);
    }

    public static <D extends StorageData, T extends IClientStorage<D>> Optional<ClientStorageInstance<D, T>> get(ResourceLocation location, Class<T> clazz) {
        return PMWClientStorages.get(location).cast(clazz);
    }

    public static Collection<? extends ClientStorageInstance<?, ?>> getAll() {
        return STORAGE_INSTANCES.values();
    }

    public static void resetAll() {
        PMWClientStorages.getAll().forEach(ClientStorageInstance::clear);
    }

    public static void loadDimension(ClientLevel clientLevel) {
        lastLevel = clientLevel;
        STORAGE_INSTANCES.forEach((location, instance) -> instance.load(clientLevel));
    }

    public static <D extends StorageData, C extends IClientStorage<D>> void registerStorage(ResourceLocation id, Class<C> clazz, Function<ClientLevel, C> creator) {
        ClientStorageInstance instance = new ClientStorageInstance(id, clazz, creator);
        STORAGE_INSTANCES.put(id, instance);
    }
}

