/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.client.storage;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.client.data.IClientStorage;
import net.nullved.pmweatherapi.storage.data.StorageData;

public class ClientStorageInstance<D extends StorageData, C extends IClientStorage<D>> {
    private final ResourceLocation id;
    private final Class<C> clazz;
    private final Function<ClientLevel, C> creator;
    private C storage;

    public ClientStorageInstance(ResourceLocation id, Class<C> clazz, Function<ClientLevel, C> creator) {
        this.id = id;
        this.clazz = clazz;
        this.creator = creator;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public C get() {
        return this.storage;
    }

    public void set(C storage) {
        this.storage = storage;
    }

    public <F extends StorageData, O extends IClientStorage<F>> Optional<ClientStorageInstance<F, O>> cast(Class<O> oclazz) {
        if (oclazz.isAssignableFrom(this.clazz)) {
            ClientStorageInstance<D, IClientStorage> casted = new ClientStorageInstance<D, IClientStorage>(this.id(), oclazz, cl -> (IClientStorage)this.creator.apply((ClientLevel)cl));
            try {
                casted.set((IClientStorage)this.storage);
                return Optional.of(casted);
            }
            catch (ClassCastException e) {
                PMWeatherAPI.LOGGER.error("Could not cast {} to {}", (Object)this.clazz.getSimpleName(), (Object)oclazz.getSimpleName());
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public void load(ClientLevel level) {
        this.storage = (IClientStorage)this.creator.apply(level);
    }

    public void clear() {
        this.storage = null;
    }
}

