/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.client.data.PMWClientStorages;
import net.nullved.pmweatherapi.data.PMWStorages;
import net.nullved.pmweatherapi.storage.IStorage;
import net.nullved.pmweatherapi.storage.data.StorageData;
import net.nullved.pmweatherapi.util.PMWUtils;

public class StoragesCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"storages").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"storage", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> {
            PMWStorages.getAll().forEach(si -> builder.suggest(si.id().toString()));
            return builder.buildFuture();
        }).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"client").then(((LiteralArgumentBuilder)Commands.literal((String)"all").then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2048)).executes(StoragesCommand::clientAll))).executes(StoragesCommand::clientAll))).then(Commands.literal((String)"adjacentChunks").executes(StoragesCommand::clientAdjacentChunks))).executes(StoragesCommand::clientAll))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").then(Commands.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)2048)).executes(StoragesCommand::serverAll))).executes(StoragesCommand::serverAll))).then(Commands.literal((String)"adjacentChunks").executes(StoragesCommand::serverAdjacentChunks))).executes(StoragesCommand::serverAll)));
    }

    private static <D extends StorageData> int clientAll(CommandContext<CommandSourceStack> ctx) {
        BiFunction<IStorage<D>, Player, Set<D>> func;
        try {
            int radius = (Integer)ctx.getArgument("radius", Integer.class);
            func = (stg, plr) -> stg.getAllWithinRange(plr.blockPosition(), radius);
        }
        catch (Exception e) {
            func = (stg, plr) -> stg.getAll();
        }
        return StoragesCommand.execClient(ctx, func);
    }

    private static <D extends StorageData> int serverAll(CommandContext<CommandSourceStack> ctx) {
        BiFunction<IStorage<D>, Player, Set<D>> func;
        try {
            int radius = (Integer)ctx.getArgument("radius", Integer.class);
            func = (stg, plr) -> stg.getAllWithinRange(plr.blockPosition(), radius);
        }
        catch (Exception e) {
            func = (stg, plr) -> stg.getAll();
        }
        return StoragesCommand.exec(ctx, func);
    }

    private static int clientAdjacentChunks(CommandContext<CommandSourceStack> ctx) {
        return StoragesCommand.execClient(ctx, (stg, plr) -> stg.getInAdjacentChunks(new ChunkPos(plr.blockPosition())));
    }

    private static int serverAdjacentChunks(CommandContext<CommandSourceStack> ctx) {
        return StoragesCommand.exec(ctx, (stg, plr) -> stg.getInAdjacentChunks(new ChunkPos(plr.blockPosition())));
    }

    private static <D extends StorageData> int exec(CommandContext<CommandSourceStack> ctx, BiFunction<IStorage<D>, Player, Set<D>> blocksFunction) {
        PMWeatherAPI.LOGGER.info("Checking for nearby storages...");
        ServerPlayer plr = ((CommandSourceStack)ctx.getSource()).getPlayer();
        ResourceLocation storage = ResourceLocationArgument.getId(ctx, (String)"storage");
        if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.pmweatherapi.non_player"));
            return 1;
        }
        long startTimeMillis = System.currentTimeMillis();
        Object stg = PMWStorages.get(storage).get((ResourceKey<Level>)plr.level().dimension());
        Set<Object> blocks = Set.of();
        if (stg != null) {
            blocks = blocksFunction.apply((IStorage<D>)stg, (Player)plr);
        }
        long elapsedTime = System.currentTimeMillis() - startTimeMillis;
        StringBuilder sb = new StringBuilder("Found ").append(blocks.size()).append(" server block positions in ").append((float)elapsedTime / 1000.0f).append("s");
        for (StorageData storageData : blocks) {
            sb.append("\nPos: ").append(storageData.getPos().toShortString());
            if (!PMWUtils.isRadarCornerAdjacent(plr.level(), storageData.getPos())) continue;
            sb.append(" (RA)");
        }
        if (PMWUtils.isRadarCornerAdjacent(plr.level(), plr.blockPosition())) {
            sb.append("\nYou are next to a radar!");
        }
        plr.sendSystemMessage((Component)Component.literal((String)sb.toString()).withColor(ChatFormatting.GOLD.getColor().intValue()));
        return 1;
    }

    private static <D extends StorageData> int execClient(CommandContext<CommandSourceStack> ctx, BiFunction<IStorage<D>, Player, Set<D>> blocksFunction) {
        PMWeatherAPI.LOGGER.info("Checking for nearby storages...");
        ServerPlayer plr = ((CommandSourceStack)ctx.getSource()).getPlayer();
        ResourceLocation storage = ResourceLocationArgument.getId(ctx, (String)"storage");
        if (!((CommandSourceStack)ctx.getSource()).isPlayer()) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"commands.pmweatherapi.non_player"));
            return 1;
        }
        long startTimeMillis = System.currentTimeMillis();
        Object stg = PMWClientStorages.get(storage).get();
        Set<Object> blocks = Set.of();
        if (stg != null) {
            blocks = blocksFunction.apply((IStorage<D>)stg, (Player)plr);
        }
        long elapsedTime = System.currentTimeMillis() - startTimeMillis;
        StringBuilder sb = new StringBuilder("Found ").append(blocks.size()).append(" client block positions in ").append((float)elapsedTime / 1000.0f).append("s");
        for (StorageData storageData : blocks) {
            sb.append("\nPos: ").append(storageData.getPos().toShortString());
            if (!PMWUtils.isRadarCornerAdjacent(plr.level(), storageData.getPos())) continue;
            sb.append(" (RA)");
        }
        if (PMWUtils.isRadarCornerAdjacent(plr.level(), plr.blockPosition())) {
            sb.append("\nYou are next to a radar!");
        }
        plr.sendSystemMessage((Component)Component.literal((String)sb.toString()).withColor(ChatFormatting.GOLD.getColor().intValue()));
        return 1;
    }
}

