/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.metar.MetarServerStorage;
import net.nullved.pmweatherapi.metar.MetarStorage;
import net.nullved.pmweatherapi.metar.MetarStorageData;
import net.nullved.pmweatherapi.radar.storage.RadarServerStorage;
import net.nullved.pmweatherapi.radar.storage.RadarStorage;
import net.nullved.pmweatherapi.radar.storage.RadarStorageData;
import net.nullved.pmweatherapi.radar.storage.WSRServerStorage;
import net.nullved.pmweatherapi.radar.storage.WSRStorage;
import net.nullved.pmweatherapi.radar.storage.WSRStorageData;
import net.nullved.pmweatherapi.storage.IServerStorage;
import net.nullved.pmweatherapi.storage.StorageInstance;
import net.nullved.pmweatherapi.storage.data.StorageData;

public class PMWStorages {
    public static final Map<ResourceLocation, StorageInstance<?, ?>> STORAGE_INSTANCES = new HashMap();

    public static StorageInstance<RadarStorageData, RadarServerStorage> radars() {
        return PMWStorages.get(RadarStorage.ID, RadarServerStorage.class).orElseThrow();
    }

    public static StorageInstance<MetarStorageData, MetarServerStorage> metars() {
        return PMWStorages.get(MetarStorage.ID, MetarServerStorage.class).orElseThrow();
    }

    public static StorageInstance<WSRStorageData, WSRServerStorage> wsrs() {
        return PMWStorages.get(WSRStorage.ID, WSRServerStorage.class).orElseThrow();
    }

    public static StorageInstance<?, ?> get(ResourceLocation location) {
        if (!STORAGE_INSTANCES.containsKey(location)) {
            PMWeatherAPI.LOGGER.error("No storage instance found for location {}", (Object)location);
        }
        return STORAGE_INSTANCES.get(location);
    }

    public static void set(ResourceLocation location, StorageInstance<?, ?> instance) {
        STORAGE_INSTANCES.put(location, instance);
    }

    public static <D extends StorageData, T extends IServerStorage<D>> Optional<StorageInstance<D, T>> get(ResourceLocation location, Class<T> clazz) {
        return STORAGE_INSTANCES.get(location).cast(clazz);
    }

    public static void resetAll() {
        PMWStorages.getAll().forEach(StorageInstance::clear);
    }

    public static Collection<? extends StorageInstance<?, ?>> getAll() {
        return STORAGE_INSTANCES.values();
    }

    public static Collection<? extends IServerStorage<?>> getForDimension(ResourceKey<Level> dimension) {
        return PMWStorages.getAll().stream().map(si -> si.get(dimension)).toList();
    }

    public static void loadDimension(ServerLevel serverLevel) {
        STORAGE_INSTANCES.forEach((rl, si) -> si.load(serverLevel));
    }

    public static void removeDimension(ResourceKey<Level> dimension) {
        STORAGE_INSTANCES.forEach((rl, si) -> si.remove(dimension));
    }

    public static <D extends StorageData, S extends IServerStorage<D>> void registerStorage(ResourceLocation id, Class<S> clazz, Function<ServerLevel, S> creator) {
        StorageInstance instance = new StorageInstance(id, clazz, creator);
        STORAGE_INSTANCES.put(id, instance);
    }
}

