/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.event;

import com.mojang.brigadier.CommandDispatcher;
import dev.protomanly.pmweather.event.GameBusEvents;
import dev.protomanly.pmweather.weather.Sounding;
import dev.protomanly.pmweather.weather.ThermodynamicEngine;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WindEngine;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.command.StoragesCommand;
import net.nullved.pmweatherapi.data.PMWStorages;
import net.nullved.pmweatherapi.metar.MetarServerStorage;
import net.nullved.pmweatherapi.metar.MetarStorageData;
import net.nullved.pmweatherapi.storage.ISyncServerStorage;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="pmweatherapi")
public class PMWEvents {
    private static int ticks = 0;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ResourceKey dimension = event.getEntity().level().dimension();
        PMWStorages.getAll().forEach(si -> {
            Object storage = si.get((ResourceKey<Level>)dimension);
            if (storage != null && storage instanceof ISyncServerStorage) {
                ISyncServerStorage isss = (ISyncServerStorage)storage;
                PMWeatherAPI.LOGGER.debug("Syncing stoage {}", (Object)isss.getId().toString());
                isss.syncAllToPlayer(event.getEntity());
            }
        });
        PMWeatherAPI.LOGGER.info("Synced all sync-storages to joined player {}", (Object)event.getEntity().getDisplayName().getString());
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PMWStorages.getForDimension((ResourceKey<Level>)event.getTo()).forEach(iss -> {
            if (iss instanceof ISyncServerStorage) {
                ISyncServerStorage isss = (ISyncServerStorage)iss;
                isss.syncAllToPlayer(event.getEntity());
            }
        });
    }

    @SubscribeEvent
    public static void onTick(ServerTickEvent.Pre event) {
        if (++ticks % 1200 == 0) {
            ticks = 0;
            PMWeatherAPI.LOGGER.info("Saving metar data!");
            PMWStorages.metars().entrySet().forEach(entry -> {
                WeatherHandler weatherHandler = (WeatherHandler)GameBusEvents.MANAGERS.get(entry.getKey());
                ArrayList updated = new ArrayList();
                ((MetarServerStorage)entry.getValue()).getAll().forEach(msd -> {
                    BlockPos pos = msd.getPos();
                    Level level = weatherHandler.getWorld();
                    Vec3 wind = WindEngine.getWind((BlockPos)pos, (Level)level);
                    int windAngle = Math.floorMod((int)Math.toDegrees(Math.atan2(wind.x, -wind.z)), 360);
                    double windspeed = wind.length();
                    ThermodynamicEngine.AtmosphericDataPoint sfc = ThermodynamicEngine.samplePoint((WeatherHandler)weatherHandler, (Vec3)pos.getCenter(), (Level)level, null, (int)0);
                    float temp = sfc.temperature();
                    float dew = sfc.dewpoint();
                    float riskV = 0.0f;
                    for (int i = 0; i < 24000; i += 200) {
                        Sounding sounding = new Sounding(weatherHandler, pos.getCenter(), level, 250, 16000, i);
                        float r = sounding.getRisk(i);
                        if (!(r > riskV)) continue;
                        riskV = r;
                    }
                    MetarStorageData newMsd = new MetarStorageData(pos, temp, dew, windAngle, (float)windspeed, riskV);
                    updated.add(newMsd);
                });
                ((MetarServerStorage)entry.getValue()).addAndSync(updated);
            });
        }
    }

    @SubscribeEvent
    public static void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        PMWeatherAPI.LOGGER.info("Registering PMWeatherAPI Commands");
        StoragesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onLevelLoadEvent(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            PMWStorages.loadDimension(slevel);
            PMWeatherAPI.LOGGER.info("Loaded storages for dimension {}", (Object)slevel.dimension().location());
        }
    }

    @SubscribeEvent
    public static void onLevelUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            PMWStorages.removeDimension((ResourceKey<Level>)slevel.dimension());
            PMWeatherAPI.LOGGER.info("Unloaded storages for dimension {}", (Object)slevel.dimension().location());
        }
    }
}

