/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.metar;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.storage.data.StorageData;

public class MetarStorageData
extends StorageData {
    public static final ResourceLocation ID = PMWeatherAPI.rl("metar");
    private float temp;
    private float dew;
    private float windAngle;
    private float windspeed;
    private float risk;

    public MetarStorageData(BlockPos pos, float temp, float dew, float windAngle, float windspeed, float risk) {
        super(pos);
        this.temp = temp;
        this.dew = dew;
        this.windAngle = windAngle;
        this.windspeed = windspeed;
        this.risk = risk;
    }

    public float getTemp() {
        return this.temp;
    }

    public float getDew() {
        return this.dew;
    }

    public float getWindAngle() {
        return this.windAngle;
    }

    public float getWindspeed() {
        return this.windspeed;
    }

    public float getRisk() {
        return this.risk;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag serializeToNBT() {
        CompoundTag tag = super.serializeToNBT();
        tag.putFloat("temp", this.temp);
        tag.putFloat("dew", this.dew);
        tag.putFloat("wind_angle", this.windAngle);
        tag.putFloat("windspeed", this.windspeed);
        tag.putFloat("risk", this.risk);
        return tag;
    }

    public static MetarStorageData deserializeFromNBT(CompoundTag tag, int version) {
        BlockPos bp = MetarStorageData.deserializeBlockPos(tag);
        if (bp == null) {
            throw new IllegalArgumentException("Could not read BlockPos in MetarStorageData!");
        }
        float temp = tag.getFloat("temp");
        float dew = tag.getFloat("dew");
        float windAngle = tag.getFloat("wind_angle");
        float windspeed = tag.getFloat("windspeed");
        float risk = tag.getFloat("risk");
        return new MetarStorageData(bp, temp, dew, windAngle, windspeed, risk);
    }
}

