/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.network;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.client.data.IClientStorage;

public abstract class S2CStoragePacket<C extends IClientStorage<?>>
implements CustomPacketPayload {
    public CompoundTag tag;

    public abstract C getStorage();

    public S2CStoragePacket(CompoundTag tag) {
        this.tag = tag;
    }

    public S2CStoragePacket(RegistryFriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public CompoundTag tag() {
        return this.tag;
    }

    public void write(FriendlyByteBuf buf) {
        this.tag.putInt("version", this.getStorage().version());
        buf.writeNbt((Tag)this.tag);
    }

    public void handle(Player player) {
        try {
            String operation = this.tag.getString("operation");
            C storage = this.getStorage();
            if (operation.equals("overwrite")) {
                storage.syncAll(this.tag);
            } else if (operation.equals("add")) {
                storage.syncAdd(this.tag);
            } else if (operation.equals("remove")) {
                storage.syncRemove(this.tag);
            } else {
                PMWeatherAPI.LOGGER.error("Unknown S2CRadarsPacket operation: {}", (Object)operation);
            }
        }
        catch (Exception e) {
            PMWeatherAPI.LOGGER.error("An error occurred when trying to write packet", (Throwable)e);
        }
    }
}

