/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.radar.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.radar.RadarMode;
import net.nullved.pmweatherapi.storage.data.StorageData;

public class RadarStorageData
extends StorageData {
    public static final ResourceLocation ID = PMWeatherAPI.rl("radar");
    private final RadarMode radarMode;
    private final boolean on;

    public RadarStorageData(BlockPos pos, RadarMode radarMode, boolean on) {
        super(pos);
        this.radarMode = radarMode;
        this.on = on;
    }

    public RadarMode getRadarMode() {
        return this.radarMode;
    }

    public boolean isOn() {
        return this.on;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag serializeToNBT() {
        CompoundTag tag = super.serializeToNBT();
        tag.putString("radar_mode", this.radarMode.getSerializedName());
        tag.putBoolean("on", this.on);
        return tag;
    }

    public static RadarStorageData deserializeFromNBT(CompoundTag tag, int version) {
        BlockPos bp = RadarStorageData.deserializeBlockPos(tag);
        if (bp != null) {
            RadarMode mode = RadarMode.get(tag.getString("radar_mode"));
            boolean on = tag.getBoolean("on");
            return new RadarStorageData(bp, mode, on);
        }
        return new RadarStorageData((BlockPos)NbtUtils.readBlockPos((CompoundTag)tag, (String)"").orElseThrow(() -> new IllegalArgumentException("Could not read BlockPos in RadarStorageData!")), RadarMode.get(tag.getString("radar_mode")), !tag.contains("on") || tag.getBoolean("on"));
    }
}

