/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.storage;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.nullved.pmweatherapi.storage.data.IStorageData;

public interface IStorage<D extends IStorageData> {
    public Level getLevel();

    public ResourceLocation getId();

    public int version();

    public void clean();

    public Set<D> getAll();

    public Set<D> getAllWithinRange(BlockPos var1, double var2);

    public Set<D> getInChunk(ChunkPos var1);

    public Set<D> getInAdjacentChunks(ChunkPos var1);

    public void forAll(Consumer<D> var1);

    public void forAllWithinRange(BlockPos var1, double var2, Consumer<D> var4);

    public void forInChunk(ChunkPos var1, Consumer<D> var2);

    public void forInAdjacentChunks(ChunkPos var1, Consumer<D> var2);

    public boolean shouldRecalculate(ChunkPos var1);

    public void add(D var1);

    public void add(Collection<D> var1);

    public void remove(D var1);

    public void removeByData(Collection<D> var1);

    public void remove(BlockPos var1);

    public void removeByPos(Collection<BlockPos> var1);

    public CompoundTag save(CompoundTag var1);

    public void read();
}

