/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.storage.IServerStorage;
import net.nullved.pmweatherapi.storage.data.IStorageData;

public class StorageInstance<D extends IStorageData, S extends IServerStorage<D>> {
    private final ResourceLocation id;
    private final Class<S> clazz;
    private final Function<ServerLevel, S> creator;
    private final HashMap<ResourceKey<Level>, S> map = new HashMap();

    public StorageInstance(ResourceLocation id, Class<S> clazz, Function<ServerLevel, S> creator) {
        this.id = id;
        this.clazz = clazz;
        this.creator = creator;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public HashMap<ResourceKey<Level>, S> getBackingMap() {
        return this.map;
    }

    public void clear() {
        this.map.clear();
    }

    public Set<ResourceKey<Level>> keySet() {
        return this.map.keySet();
    }

    public Collection<S> values() {
        return this.map.values();
    }

    public Set<Map.Entry<ResourceKey<Level>, S>> entrySet() {
        return this.map.entrySet();
    }

    public S get(ResourceKey<Level> dimension) {
        return (S)((IServerStorage)this.map.get(dimension));
    }

    public S getOrCreate(ServerLevel level) {
        return (S)this.map.computeIfAbsent((ResourceKey<Level>)level.dimension(), dim -> {
            IServerStorage storage = (IServerStorage)this.creator.apply(level);
            storage.read();
            return storage;
        });
    }

    public <F extends IStorageData, O extends IServerStorage<F>> Optional<StorageInstance<F, O>> cast(Class<O> oclazz) {
        if (oclazz.isAssignableFrom(this.clazz)) {
            StorageInstance<D, IServerStorage> casted = new StorageInstance<D, IServerStorage>(this.id(), oclazz, sl -> (IServerStorage)this.creator.apply((ServerLevel)sl));
            HashMap<ResourceKey<Level>, IServerStorage> backingMap = casted.getBackingMap();
            try {
                for (Map.Entry<ResourceKey<Level>, S> entry : this.map.entrySet()) {
                    backingMap.put(entry.getKey(), (IServerStorage)oclazz.cast(entry.getValue()));
                }
                return Optional.of(casted);
            }
            catch (ClassCastException e) {
                PMWeatherAPI.LOGGER.error("Could not cast {} to {}", (Object)this.clazz.getSimpleName(), (Object)oclazz.getSimpleName());
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public void load(ServerLevel level) {
        IServerStorage storage = (IServerStorage)this.creator.apply(level);
        storage.read();
        this.map.put((ResourceKey<Level>)level.dimension(), storage);
    }

    public void remove(ResourceKey<Level> dimension) {
        IServerStorage storage = (IServerStorage)this.map.get(dimension);
        this.map.remove(dimension);
    }
}

