/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.storage.data;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.nullved.pmweatherapi.PMWeatherAPI;
import net.nullved.pmweatherapi.storage.data.BlockPosData;
import net.nullved.pmweatherapi.storage.data.IStorageData;

public class StorageDataManager {
    public static final HashMap<ResourceLocation, BiFunction<CompoundTag, Integer, ? extends IStorageData>> map = new HashMap();

    public static <D extends IStorageData> void register(ResourceLocation id, BiFunction<CompoundTag, Integer, D> deserializer) {
        map.put(id, deserializer);
    }

    public static <D extends IStorageData> D get(CompoundTag tag, int version) {
        try {
            if (tag.getString("type").isEmpty()) {
                Optional bp = NbtUtils.readBlockPos((CompoundTag)tag, (String)"blockpos");
                if (bp.isPresent()) {
                    return (D)new BlockPosData((BlockPos)bp.get());
                }
                throw new IllegalArgumentException("No type given and does not meet BlockPos criteria");
            }
            return (D)map.get(ResourceLocation.parse((String)tag.getString("type"))).apply(tag, version);
        }
        catch (Exception e) {
            PMWeatherAPI.LOGGER.error("Could not deserialize tag {} of type {}: {}", new Object[]{NbtUtils.toPrettyComponent((Tag)tag), tag.get("type"), e.getMessage()});
            return null;
        }
    }
}

