/*
 * Decompiled with CFR 0.152.
 */
package net.nullved.pmweatherapi.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.nullved.pmweatherapi.radar.NearbyRadars;
import net.nullved.pmweatherapi.storage.IStorage;
import net.nullved.pmweatherapi.storage.data.StorageData;

public class PMWUtils {
    public static boolean isCornerAdjacent(BlockPos a, BlockPos b) {
        int dx = Math.abs(a.getX() - b.getX());
        int dy = Math.abs(a.getY() - b.getY());
        int dz = Math.abs(a.getZ() - b.getZ());
        return dx <= 1 && dy <= 1 && dz <= 1 && dx + dy + dz > 0;
    }

    public static Set<BlockPos> testAround(BlockPos pos, Function<BlockPos, Boolean> test) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0 || !test.apply(pos.offset(x, y, z)).booleanValue()) continue;
                    set.add(pos.offset(x, y, z));
                }
            }
        }
        return set;
    }

    public static <D extends StorageData> Set<D> storageCornerAdjacent(IStorage<D> storage, BlockPos pos) {
        HashSet<StorageData> set = new HashSet<StorageData>();
        for (StorageData data : storage.getInAdjacentChunks(new ChunkPos(pos))) {
            if (!PMWUtils.isCornerAdjacent(data.getPos(), pos)) continue;
            set.add(data);
        }
        return set;
    }

    public static boolean isRadarAdjacent(ResourceKey<Level> dim, BlockPos pos) {
        return !NearbyRadars.get(dim).radarsNearBlock(pos, 1.0).isEmpty();
    }

    public static boolean isRadarAdjacent(Level level, BlockPos pos) {
        return PMWUtils.isRadarAdjacent((ResourceKey<Level>)level.dimension(), pos);
    }

    public static boolean isRadarCornerAdjacent(ResourceKey<Level> dim, BlockPos pos) {
        Set<BlockPos> nearby = NearbyRadars.get(dim).radarsNearBlock(pos, 3.0);
        boolean adj = false;
        for (BlockPos nearbyPos : nearby) {
            adj |= PMWUtils.isCornerAdjacent(nearbyPos, pos);
        }
        return adj;
    }

    public static boolean isRadarCornerAdjacent(Level level, BlockPos pos) {
        return PMWUtils.isRadarCornerAdjacent((ResourceKey<Level>)level.dimension(), pos);
    }
}

