/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.povstalec.stellarview.api.common.space_objects.distinct.Luna;
import net.povstalec.stellarview.api.common.space_objects.distinct.Sol;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.BlackHole;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Constellation;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Moon;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Nebula;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Planet;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Star;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.client.SpaceObjectRenderers;
import net.povstalec.stellarview.client.render.space_objects.distinct.LunaRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.BlackHoleRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.ConstellationRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.MoonRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.NebulaRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.PlanetRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.StarFieldRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.StarRenderer;
import net.povstalec.stellarview.common.config.StellarViewConfig;
import net.povstalec.stellarview.common.config.StellarViewConfigSpec;

@Environment(value=EnvType.CLIENT)
public class StellarViewClient
implements ClientModInitializer {
    public void onInitializeClient() {
        SpaceObjectRenderers.register(Planet.class, PlanetRenderer::new);
        SpaceObjectRenderers.register(Moon.class, MoonRenderer::new);
        SpaceObjectRenderers.register(Luna.class, LunaRenderer::new);
        SpaceObjectRenderers.register(Star.class, StarRenderer::new);
        SpaceObjectRenderers.register(Sol.class, StarRenderer::new);
        SpaceObjectRenderers.register(BlackHole.class, BlackHoleRenderer::new);
        SpaceObjectRenderers.register(Nebula.class, NebulaRenderer::new);
        SpaceObjectRenderers.register(StarField.class, StarFieldRenderer::new);
        SpaceObjectRenderers.register(Constellation.class, ConstellationRenderer::new);
        StellarViewClient.registerConfig(StellarViewConfig.CLIENT_CONFIG, "stellarview-client.toml");
    }

    private static void registerConfig(StellarViewConfigSpec config, String fileName) {
        config.register(fileName);
    }
}

