/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_5321;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.client.resourcepack.Skybox;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.client.resourcepack.effects.MeteorEffect;
import net.povstalec.stellarview.common.config.EndConfig;
import net.povstalec.stellarview.common.config.NetherConfig;
import net.povstalec.stellarview.common.config.OverworldConfig;
import net.povstalec.stellarview.common.util.AxisRotation;

public final class DefaultViewCenters {

    public static class End
    extends ViewCenter {
        public static final Codec<End> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.RESOURCE_KEY_CODEC.optionalFieldOf("view_center").forGetter(ViewCenter::getViewCenterKey), (App)Skybox.CODEC.listOf().optionalFieldOf("skyboxes").forGetter(ViewCenter::getSkyboxes), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(ViewCenter::getAxisRotation), (App)Codec.LONG.optionalFieldOf("rotation_period", (Object)0L).forGetter(ViewCenter::getRotationPeriod), (App)ViewCenter.DayBlending.CODEC.optionalFieldOf("day_blending", (Object)ViewCenter.DayBlending.DAY_BLENDING).forGetter(viewCenter -> viewCenter.dayBlending), (App)ViewCenter.DayBlending.CODEC.optionalFieldOf("sun_day_blending", (Object)ViewCenter.DayBlending.SUN_DAY_BLENDING).forGetter(viewCenter -> viewCenter.sunDayBlending), (App)MeteorEffect.ShootingStar.CODEC.optionalFieldOf("shooting_star").forGetter(viewCenter -> Optional.ofNullable(viewCenter.shootingStar)), (App)MeteorEffect.MeteorShower.CODEC.optionalFieldOf("meteor_shower").forGetter(viewCenter -> Optional.ofNullable(viewCenter.meteorShower)), (App)Codec.BOOL.optionalFieldOf("create_horizon", (Object)true).forGetter(viewCenter -> viewCenter.createHorizon), (App)Codec.BOOL.optionalFieldOf("create_void", (Object)true).forGetter(viewCenter -> viewCenter.createVoid), (App)ViewCenter.Stars.CODEC.optionalFieldOf("stars", (Object)new ViewCenter.Stars()).forGetter(viewCenter -> viewCenter.stars), (App)ViewCenter.Fog.CODEC.optionalFieldOf("fog", (Object)new ViewCenter.Fog()).forGetter(viewCenter -> viewCenter.fog), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("z_rotation_multiplier", (Object)0).forGetter(viewCenter -> viewCenter.zRotationMultiplier)).apply((Applicative)instance, End::new));

        public End(Optional<class_5321<SpaceObject>> viewCenterKey, Optional<List<Skybox>> skyboxes, AxisRotation axisRotation, long rotationPeriod, ViewCenter.DayBlending dayBlending, ViewCenter.DayBlending sunDayBlending, Optional<MeteorEffect.ShootingStar> shootingStar, Optional<MeteorEffect.MeteorShower> meteorShower, boolean createHorizon, boolean createVoid, ViewCenter.Stars stars, ViewCenter.Fog fog, int zRotationMultiplier) {
            super(viewCenterKey, skyboxes, axisRotation, rotationPeriod, dayBlending, sunDayBlending, shootingStar, meteorShower, createHorizon, createVoid, stars, fog, zRotationMultiplier);
        }

        @Override
        public boolean overrideMeteorEffects() {
            return EndConfig.config_priority.get();
        }

        @Override
        public double overrideShootingStarRarity() {
            return EndConfig.shooting_star_chance.get();
        }

        @Override
        public double overrideMeteorShowerRarity() {
            return EndConfig.meteor_shower_chance.get();
        }
    }

    public static class Nether
    extends ViewCenter {
        public static final Codec<Nether> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.RESOURCE_KEY_CODEC.optionalFieldOf("view_center").forGetter(ViewCenter::getViewCenterKey), (App)Skybox.CODEC.listOf().optionalFieldOf("skyboxes").forGetter(ViewCenter::getSkyboxes), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(ViewCenter::getAxisRotation), (App)Codec.LONG.optionalFieldOf("rotation_period", (Object)0L).forGetter(ViewCenter::getRotationPeriod), (App)ViewCenter.DayBlending.CODEC.optionalFieldOf("day_blending", (Object)ViewCenter.DayBlending.DAY_BLENDING).forGetter(viewCenter -> viewCenter.dayBlending), (App)ViewCenter.DayBlending.CODEC.optionalFieldOf("sun_day_blending", (Object)ViewCenter.DayBlending.SUN_DAY_BLENDING).forGetter(viewCenter -> viewCenter.sunDayBlending), (App)MeteorEffect.ShootingStar.CODEC.optionalFieldOf("shooting_star").forGetter(viewCenter -> Optional.ofNullable(viewCenter.shootingStar)), (App)MeteorEffect.MeteorShower.CODEC.optionalFieldOf("meteor_shower").forGetter(viewCenter -> Optional.ofNullable(viewCenter.meteorShower)), (App)Codec.BOOL.optionalFieldOf("create_horizon", (Object)true).forGetter(viewCenter -> viewCenter.createHorizon), (App)Codec.BOOL.optionalFieldOf("create_void", (Object)true).forGetter(viewCenter -> viewCenter.createVoid), (App)ViewCenter.Stars.CODEC.optionalFieldOf("stars", (Object)new ViewCenter.Stars()).forGetter(viewCenter -> viewCenter.stars), (App)ViewCenter.Fog.CODEC.optionalFieldOf("fog", (Object)new ViewCenter.Fog()).forGetter(viewCenter -> viewCenter.fog), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("z_rotation_multiplier", (Object)0).forGetter(viewCenter -> viewCenter.zRotationMultiplier)).apply((Applicative)instance, Nether::new));

        public Nether(Optional<class_5321<SpaceObject>> viewCenterKey, Optional<List<Skybox>> skyboxes, AxisRotation axisRotation, long rotationPeriod, ViewCenter.DayBlending dayBlending, ViewCenter.DayBlending sunDayBlending, Optional<MeteorEffect.ShootingStar> shootingStar, Optional<MeteorEffect.MeteorShower> meteorShower, boolean createHorizon, boolean createVoid, ViewCenter.Stars stars, ViewCenter.Fog fog, int zRotationMultiplier) {
            super(viewCenterKey, skyboxes, axisRotation, rotationPeriod, dayBlending, sunDayBlending, shootingStar, meteorShower, createHorizon, createVoid, stars, fog, zRotationMultiplier);
        }

        @Override
        public boolean overrideMeteorEffects() {
            return NetherConfig.config_priority.get();
        }

        @Override
        public double overrideShootingStarRarity() {
            return NetherConfig.shooting_star_chance.get();
        }

        @Override
        public double overrideMeteorShowerRarity() {
            return NetherConfig.meteor_shower_chance.get();
        }
    }

    public static class Overworld
    extends ViewCenter {
        public static final Codec<Overworld> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.RESOURCE_KEY_CODEC.optionalFieldOf("view_center").forGetter(ViewCenter::getViewCenterKey), (App)Skybox.CODEC.listOf().optionalFieldOf("skyboxes").forGetter(ViewCenter::getSkyboxes), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(ViewCenter::getAxisRotation), (App)Codec.LONG.optionalFieldOf("rotation_period", (Object)0L).forGetter(ViewCenter::getRotationPeriod), (App)ViewCenter.DayBlending.CODEC.optionalFieldOf("day_blending", (Object)ViewCenter.DayBlending.DAY_BLENDING).forGetter(viewCenter -> viewCenter.dayBlending), (App)ViewCenter.DayBlending.CODEC.optionalFieldOf("sun_day_blending", (Object)ViewCenter.DayBlending.SUN_DAY_BLENDING).forGetter(viewCenter -> viewCenter.sunDayBlending), (App)MeteorEffect.ShootingStar.CODEC.optionalFieldOf("shooting_star").forGetter(viewCenter -> Optional.ofNullable(viewCenter.shootingStar)), (App)MeteorEffect.MeteorShower.CODEC.optionalFieldOf("meteor_shower").forGetter(viewCenter -> Optional.ofNullable(viewCenter.meteorShower)), (App)Codec.BOOL.optionalFieldOf("create_horizon", (Object)true).forGetter(viewCenter -> viewCenter.createHorizon), (App)Codec.BOOL.optionalFieldOf("create_void", (Object)true).forGetter(viewCenter -> viewCenter.createVoid), (App)ViewCenter.Stars.CODEC.optionalFieldOf("stars", (Object)new ViewCenter.Stars()).forGetter(viewCenter -> viewCenter.stars), (App)ViewCenter.Fog.CODEC.optionalFieldOf("fog", (Object)new ViewCenter.Fog()).forGetter(viewCenter -> viewCenter.fog), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("z_rotation_multiplier", (Object)30000000).forGetter(viewCenter -> viewCenter.zRotationMultiplier)).apply((Applicative)instance, Overworld::new));

        public Overworld(Optional<class_5321<SpaceObject>> viewCenterKey, Optional<List<Skybox>> skyboxes, AxisRotation axisRotation, long rotationPeriod, ViewCenter.DayBlending dayBlending, ViewCenter.DayBlending sunDayBlending, Optional<MeteorEffect.ShootingStar> shootingStar, Optional<MeteorEffect.MeteorShower> meteorShower, boolean createHorizon, boolean createVoid, ViewCenter.Stars stars, ViewCenter.Fog fog, int zRotationMultiplier) {
            super(viewCenterKey, skyboxes, axisRotation, rotationPeriod, dayBlending, sunDayBlending, shootingStar, meteorShower, createHorizon, createVoid, stars, fog, zRotationMultiplier);
        }

        @Override
        public double zRotationMultiplier() {
            return OverworldConfig.config_priority.get() ? (double)(10000 * OverworldConfig.overworld_z_rotation_multiplier.get()) : (double)this.zRotationMultiplier;
        }

        @Override
        public boolean overrideMeteorEffects() {
            return OverworldConfig.config_priority.get();
        }

        @Override
        public double overrideShootingStarRarity() {
            return OverworldConfig.shooting_star_chance.get();
        }

        @Override
        public double overrideMeteorShowerRarity() {
            return OverworldConfig.meteor_shower_chance.get();
        }
    }
}

