/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.resourcepack;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.UV;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class Skybox {
    public static final float DEFAULT_DISTANCE = 150.0f;
    public static final Vector3f[][] BOX_COORDS = new Vector3f[][]{{new Vector3f(-150.0f, 150.0f, 150.0f), new Vector3f(-150.0f, 150.0f, -150.0f), new Vector3f(150.0f, 150.0f, -150.0f), new Vector3f(150.0f, 150.0f, 150.0f)}, {new Vector3f(150.0f, 150.0f, 150.0f), new Vector3f(150.0f, -150.0f, 150.0f), new Vector3f(-150.0f, -150.0f, 150.0f), new Vector3f(-150.0f, 150.0f, 150.0f)}, {new Vector3f(-150.0f, 150.0f, 150.0f), new Vector3f(-150.0f, -150.0f, 150.0f), new Vector3f(-150.0f, -150.0f, -150.0f), new Vector3f(-150.0f, 150.0f, -150.0f)}, {new Vector3f(-150.0f, 150.0f, -150.0f), new Vector3f(-150.0f, -150.0f, -150.0f), new Vector3f(150.0f, -150.0f, -150.0f), new Vector3f(150.0f, 150.0f, -150.0f)}, {new Vector3f(150.0f, 150.0f, -150.0f), new Vector3f(150.0f, -150.0f, -150.0f), new Vector3f(150.0f, -150.0f, 150.0f), new Vector3f(150.0f, 150.0f, 150.0f)}, {new Vector3f(-150.0f, -150.0f, -150.0f), new Vector3f(-150.0f, -150.0f, 150.0f), new Vector3f(150.0f, -150.0f, 150.0f), new Vector3f(150.0f, -150.0f, -150.0f)}};
    private SkyboxFacade[] facades = new SkyboxFacade[6];
    public static final Codec<Skybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SkyboxFacade.CODEC.fieldOf("top_facade").forGetter(Skybox::topFacade), (App)SkyboxFacade.CODEC.fieldOf("north_facade").forGetter(Skybox::northFacade), (App)SkyboxFacade.CODEC.fieldOf("east_facade").forGetter(Skybox::eastFacade), (App)SkyboxFacade.CODEC.fieldOf("south_facade").forGetter(Skybox::southFacade), (App)SkyboxFacade.CODEC.fieldOf("west_facade").forGetter(Skybox::westFacade), (App)SkyboxFacade.CODEC.fieldOf("bottom_facade").forGetter(Skybox::bottomFacade)).apply((Applicative)instance, Skybox::new));

    public Skybox(SkyboxFacade topFacade, SkyboxFacade northFacade, SkyboxFacade eastFacade, SkyboxFacade southFacade, SkyboxFacade westFacade, SkyboxFacade bottomFacade) {
        this.facades[0] = topFacade;
        this.facades[1] = northFacade;
        this.facades[2] = eastFacade;
        this.facades[3] = southFacade;
        this.facades[4] = westFacade;
        this.facades[5] = bottomFacade;
    }

    public SkyboxFacade topFacade() {
        return this.facades[0];
    }

    public SkyboxFacade northFacade() {
        return this.facades[1];
    }

    public SkyboxFacade eastFacade() {
        return this.facades[2];
    }

    public SkyboxFacade southFacade() {
        return this.facades[3];
    }

    public SkyboxFacade westFacade() {
        return this.facades[4];
    }

    public SkyboxFacade bottomFacade() {
        return this.facades[5];
    }

    public void render(class_638 level, float partialTicks, class_4587 stack, class_287 bufferbuilder) {
        stack.method_22903();
        Matrix4f lastMatrix = stack.method_23760().method_23761();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < 6; ++i) {
            this.renderFacade(bufferbuilder, lastMatrix, this.facades[i], i);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        stack.method_22909();
    }

    protected void renderFacade(class_287 bufferbuilder, Matrix4f lastMatrix, SkyboxFacade facade, int i) {
        UV.Quad uv = facade.uv();
        Color.IntRGBA rgba = facade.rgba();
        RenderSystem.setShaderTexture((int)0, (class_2960)facade.texture());
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(lastMatrix, Skybox.BOX_COORDS[i][0].x, Skybox.BOX_COORDS[i][0].y, Skybox.BOX_COORDS[i][0].z).method_22913(uv.topLeft().u(), uv.topLeft().v()).method_1336(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).method_1344();
        bufferbuilder.method_22918(lastMatrix, Skybox.BOX_COORDS[i][1].x, Skybox.BOX_COORDS[i][1].y, Skybox.BOX_COORDS[i][1].z).method_22913(uv.bottomLeft().u(), uv.bottomLeft().v()).method_1336(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).method_1344();
        bufferbuilder.method_22918(lastMatrix, Skybox.BOX_COORDS[i][2].x, Skybox.BOX_COORDS[i][2].y, Skybox.BOX_COORDS[i][2].z).method_22913(uv.bottomRight().u(), uv.bottomRight().v()).method_1336(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).method_1344();
        bufferbuilder.method_22918(lastMatrix, Skybox.BOX_COORDS[i][3].x, Skybox.BOX_COORDS[i][3].y, Skybox.BOX_COORDS[i][3].z).method_22913(uv.topRight().u(), uv.topRight().v()).method_1336(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).method_1344();
        class_286.method_43433((class_287.class_7433)bufferbuilder.method_1326());
    }

    public static class SkyboxFacade {
        private final class_2960 texture;
        private final UV.Quad uv;
        private final Color.IntRGBA rgba;
        public static final Codec<SkyboxFacade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("texture").forGetter(SkyboxFacade::texture), (App)UV.Quad.CODEC.fieldOf("uv").forGetter(SkyboxFacade::uv), (App)Color.IntRGBA.CODEC.fieldOf("rgba").forGetter(SkyboxFacade::rgba)).apply((Applicative)instance, SkyboxFacade::new));

        public SkyboxFacade(class_2960 texture, UV.Quad uv, Color.IntRGBA rgba) {
            this.texture = new class_2960(texture.method_12836(), "textures/" + texture.method_12832());
            this.uv = uv;
            this.rgba = rgba;
        }

        public class_2960 texture() {
            return this.texture;
        }

        public UV.Quad uv() {
            return this.uv;
        }

        public Color.IntRGBA rgba() {
            return this.rgba;
        }
    }
}

