/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.povstalec.stellarview.api.common.space_objects.StarLike;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.ISerializable;

public class StarInfo
implements ISerializable {
    public static final String LOD1_TYPES = "lod1_types";
    public static final String LOD2_TYPES = "lod2_types";
    public static final String LOD3_TYPES = "lod3_types";
    public static final String LOD1_WEIGHT = "lod1_weight";
    public static final String LOD2_WEIGHT = "lod2_weight";
    public static final String LOD3_WEIGHT = "lod3_weight";
    private ArrayList<StarLike.StarType> lod1Types;
    private ArrayList<StarLike.StarType> lod2Types;
    private ArrayList<StarLike.StarType> lod3Types;
    private int lod1Weight = 0;
    private int lod2Weight = 0;
    private int lod3Weight = 0;
    public static final StarLike.StarType WHITE_STAR = new StarLike.StarType(new Color.IntRGB(255, 255, 255), 0.15f, 0.25f, 100, 255, 6000000L, 1);
    public static final List<StarLike.StarType> DEFAULT_STARS = Arrays.asList(WHITE_STAR);
    public static final StarInfo DEFAULT_STAR_INFO = new StarInfo(DEFAULT_STARS);
    public static final Codec<StarInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StarLike.StarType.CODEC.listOf().fieldOf("star_types").forGetter(starInfo -> new ArrayList())).apply((Applicative)instance, StarInfo::new));

    public StarInfo() {
    }

    public StarInfo(List<StarLike.StarType> starTypes) {
        block4: for (StarLike.StarType starType : starTypes) {
            switch (StarField.LevelOfDetail.fromDistance(starType.getMaxVisibleDistance())) {
                case LOD1: {
                    if (this.lod1Types == null) {
                        this.lod1Types = new ArrayList();
                    }
                    this.lod1Types.add(starType);
                    this.lod1Weight += starType.getWeight();
                    continue block4;
                }
                case LOD2: {
                    if (this.lod2Types == null) {
                        this.lod2Types = new ArrayList();
                    }
                    this.lod2Types.add(starType);
                    this.lod2Weight += starType.getWeight();
                    continue block4;
                }
            }
            if (this.lod3Types == null) {
                this.lod3Types = new ArrayList();
            }
            this.lod3Types.add(starType);
            this.lod3Weight += starType.getWeight();
        }
    }

    public StarInfo(List<StarLike.StarType> lod1Types, List<StarLike.StarType> lod2Types, List<StarLike.StarType> lod3Types, int lod1Weight, int lod2Weight, int lod3Weight) {
        if (lod1Types != null) {
            this.lod1Types = new ArrayList<StarLike.StarType>(lod1Types);
        }
        if (lod2Types != null) {
            this.lod2Types = new ArrayList<StarLike.StarType>(lod2Types);
        }
        if (lod3Types != null) {
            this.lod3Types = new ArrayList<StarLike.StarType>(lod3Types);
        }
        this.lod1Weight = lod1Weight;
        this.lod2Weight = lod2Weight;
        this.lod3Weight = lod3Weight;
    }

    private StarLike.StarType randomStarType(ArrayList<StarLike.StarType> lodTypes, int totalWeight, Random random) {
        int i;
        if (lodTypes == null || lodTypes.isEmpty()) {
            return WHITE_STAR;
        }
        int weight = random.nextInt(0, totalWeight);
        for (i = 0; i < lodTypes.size() - 1 && (weight -= lodTypes.get(i).getWeight()) > 0; ++i) {
        }
        return lodTypes.get(i);
    }

    public StarLike.StarType randomLOD1StarType(Random random) {
        return this.randomStarType(this.lod1Types, this.lod1Weight, random);
    }

    public StarLike.StarType randomLOD2StarType(Random random) {
        return this.randomStarType(this.lod2Types, this.lod2Weight, random);
    }

    public StarLike.StarType randomLOD3StarType(Random random) {
        return this.randomStarType(this.lod3Types, this.lod3Weight, random);
    }

    public int totalWeight() {
        return this.lod1Weight + this.lod2Weight + this.lod3Weight;
    }

    public int lod1Weight() {
        return this.lod1Weight;
    }

    public int lod2Weight() {
        return this.lod2Weight;
    }

    public int lod3Weight() {
        return this.lod3Weight;
    }

    private static class_2487 serializeLODTypes(ArrayList<StarLike.StarType> lodTypes) {
        class_2487 starTypesTag = new class_2487();
        for (int i = 0; i < lodTypes.size(); ++i) {
            starTypesTag.method_10566("star_type_" + i, (class_2520)lodTypes.get(i).serializeNBT());
        }
        return starTypesTag;
    }

    private static ArrayList<StarLike.StarType> getLODTypes(class_2487 tag, String key) {
        ArrayList<StarLike.StarType> lodTypes;
        if (tag.method_10545(key)) {
            lodTypes = new ArrayList<StarLike.StarType>();
            class_2487 starTypesTag = tag.method_10562(key);
            for (int i = 0; i < starTypesTag.method_10546(); ++i) {
                StarLike.StarType starType = new StarLike.StarType();
                starType.deserializeNBT(starTypesTag.method_10562("star_type_" + i));
                lodTypes.add(starType);
            }
        } else {
            lodTypes = null;
        }
        return lodTypes;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        if (this.lod1Types != null) {
            tag.method_10566(LOD1_TYPES, (class_2520)StarInfo.serializeLODTypes(this.lod1Types));
        }
        if (this.lod2Types != null) {
            tag.method_10566(LOD2_TYPES, (class_2520)StarInfo.serializeLODTypes(this.lod2Types));
        }
        if (this.lod3Types != null) {
            tag.method_10566(LOD3_TYPES, (class_2520)StarInfo.serializeLODTypes(this.lod3Types));
        }
        tag.method_10569(LOD1_WEIGHT, this.lod1Weight);
        tag.method_10569(LOD2_WEIGHT, this.lod2Weight);
        tag.method_10569(LOD3_WEIGHT, this.lod3Weight);
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        this.lod1Types = StarInfo.getLODTypes(tag, LOD1_TYPES);
        this.lod2Types = StarInfo.getLODTypes(tag, LOD2_TYPES);
        this.lod3Types = StarInfo.getLODTypes(tag, LOD3_TYPES);
        this.lod1Weight = tag.method_10550(LOD1_WEIGHT);
        this.lod2Weight = tag.method_10550(LOD2_WEIGHT);
        this.lod3Weight = tag.method_10550(LOD3_WEIGHT);
    }
}

