/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.ISerializable;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import org.jetbrains.annotations.Nullable;

public abstract class SpaceObject
implements ISerializable {
    public static final String PARENT = "parent";
    public static final String COORDS = "coords";
    public static final String AXIS_ROTATION = "axis_rotation";
    public static final String ID = "id";
    public static final class_2960 SPACE_OBJECT_LOCATION = class_2960.method_60655((String)"stellarview", (String)"space_object");
    public static final class_5321<class_2378<SpaceObject>> REGISTRY_KEY = class_5321.method_29180((class_2960)SPACE_OBJECT_LOCATION);
    public static final Codec<class_5321<SpaceObject>> RESOURCE_KEY_CODEC = class_5321.method_39154(REGISTRY_KEY);
    @Nullable
    protected ParentInfo parentInfo;
    @Nullable
    protected SpaceObject parent;
    protected ArrayList<SpaceObject> children = new ArrayList();
    protected SpaceCoords coords;
    protected AxisRotation axisRotation;
    protected class_2960 location;

    public SpaceObject() {
    }

    public SpaceObject(Optional<ParentInfo> parentInfo, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation) {
        this.parentInfo = parentInfo.orElse(null);
        this.coords = coords.left().isPresent() ? (SpaceCoords)coords.left().get() : ((StellarCoordinates.Equatorial)coords.right().get()).toGalactic().toSpaceCoords();
        this.axisRotation = axisRotation;
    }

    public SpaceCoords getCoords() {
        return this.coords;
    }

    public AxisRotation getAxisRotation() {
        return this.axisRotation;
    }

    public ArrayList<SpaceObject> getChildren() {
        return this.children;
    }

    public Optional<ParentInfo> getParentInfo() {
        return Optional.ofNullable(this.parentInfo);
    }

    @Nullable
    public class_2960 getParentLocation() {
        if (this.parentInfo != null) {
            return this.parentInfo.parentLocation();
        }
        return null;
    }

    public boolean isRelative() {
        if (this.parentInfo != null) {
            return this.parentInfo.relative();
        }
        return true;
    }

    public Optional<SpaceObject> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public void setResourceLocation(class_2960 resourceLocation) {
        this.location = resourceLocation;
    }

    public static double distanceSize(double distance) {
        return 1.0 / distance;
    }

    public void setPosAndRotation(SpaceCoords coords, AxisRotation axisRotation) {
        this.removeCoordsAndRotationFromChildren(this.getCoords(), this.getAxisRotation());
        if (this.parent != null && this.isRelative()) {
            this.coords = coords.add(this.parent.getCoords());
            this.axisRotation = axisRotation.add(this.parent.getAxisRotation());
        } else {
            this.coords = coords;
            this.axisRotation = axisRotation;
        }
        this.addCoordsAndRotationToChildren(this.coords, this.axisRotation);
    }

    public void addParent(SpaceObject parent) {
        this.parent = parent;
    }

    public boolean addChildRaw(SpaceObject child) {
        if (child.parent != null) {
            StellarView.LOGGER.error(this.toString() + " already has a parent");
            return false;
        }
        this.children.add(child);
        child.addParent(this);
        return true;
    }

    public void addChild(SpaceObject child) {
        if (!this.addChildRaw(child)) {
            return;
        }
        if (child.isRelative()) {
            child.coords = child.coords.add(this.coords);
            child.axisRotation = child.axisRotation.add(this.axisRotation);
            child.addCoordsAndRotationToChildren(this.coords, this.axisRotation);
        }
    }

    protected void addCoordsAndRotationToChildren(SpaceCoords coords, AxisRotation axisRotation) {
        for (SpaceObject childOfChild : this.children) {
            if (!childOfChild.isRelative()) continue;
            childOfChild.coords = childOfChild.coords.add(coords);
            childOfChild.axisRotation = childOfChild.axisRotation.add(axisRotation);
            childOfChild.addCoordsAndRotationToChildren(coords, axisRotation);
        }
    }

    protected void removeCoordsAndRotationFromChildren(SpaceCoords coords, AxisRotation axisRotation) {
        for (SpaceObject childOfChild : this.children) {
            if (!childOfChild.isRelative()) continue;
            childOfChild.coords = childOfChild.coords.sub(coords);
            childOfChild.axisRotation = childOfChild.axisRotation.sub(axisRotation);
            childOfChild.removeCoordsAndRotationFromChildren(coords, axisRotation);
        }
    }

    public String toString() {
        if (this.location != null) {
            return this.location.toString();
        }
        return this.getClass().toString();
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        if (this.location != null) {
            tag.method_10582(ID, this.location.toString());
        }
        if (this.parentInfo != null) {
            tag.method_10566(PARENT, (class_2520)this.parentInfo.serializeNBT());
        }
        tag.method_10566(COORDS, (class_2520)this.coords.serializeNBT());
        tag.method_10566(AXIS_ROTATION, (class_2520)this.axisRotation.serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        if (tag.method_10545(ID)) {
            this.location = class_2960.method_60654((String)tag.method_10558(ID));
        }
        if (tag.method_10545(PARENT)) {
            this.parentInfo = new ParentInfo();
            this.parentInfo.deserializeNBT(tag.method_10562(PARENT));
        }
        this.coords = new SpaceCoords();
        this.coords.deserializeNBT(tag.method_10562(COORDS));
        this.axisRotation = new AxisRotation();
        this.axisRotation.deserializeNBT(tag.method_10562(AXIS_ROTATION));
    }

    public static class ParentInfo
    implements ISerializable {
        public static final String PARENT_LOCATION = "location";
        public static final String RELATIVE = "relative";
        public static final Codec<ParentInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf(PARENT_LOCATION).forGetter(ParentInfo::parentLocation), (App)Codec.BOOL.optionalFieldOf(RELATIVE, (Object)true).forGetter(ParentInfo::relative)).apply((Applicative)instance, ParentInfo::new));
        protected class_2960 parentLocation;
        protected boolean relative;

        public ParentInfo() {
        }

        public ParentInfo(class_2960 parentLocation, boolean relative) {
            this.parentLocation = parentLocation;
            this.relative = relative;
        }

        public class_2960 parentLocation() {
            return this.parentLocation;
        }

        public boolean relative() {
            return this.relative;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10582(PARENT_LOCATION, this.parentLocation.toString());
            tag.method_10556(RELATIVE, this.relative);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            this.parentLocation = class_2960.method_60654((String)tag.method_10558(PARENT_LOCATION));
            this.relative = tag.method_10577(RELATIVE);
        }
    }
}

