/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.ISerializable;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import org.jetbrains.annotations.Nullable;

public class Constellation
extends SpaceObject {
    public static final String STAR_TEXTURE = "star_texture";
    public static final String STARS = "stars";
    public static final String LOD1_STARS = "lod1_stars";
    public static final String LOD2_STARS = "lod2_stars";
    public static final String LOD3_STARS = "lod3_stars";
    private ArrayList<StarDefinition> lod1stars = new ArrayList();
    private ArrayList<StarDefinition> lod2stars = new ArrayList();
    private ArrayList<StarDefinition> lod3stars = new ArrayList();
    @Nullable
    protected class_2960 starTexture;
    public static final Codec<Constellation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.ParentInfo.CODEC.optionalFieldOf("parent").forGetter(SpaceObject::getParentInfo), (App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(constellation -> Either.left((Object)constellation.getCoords())), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(SpaceObject::getAxisRotation), (App)class_2960.field_25139.optionalFieldOf(STAR_TEXTURE).forGetter(constellation -> Optional.of(constellation.starTexture)), (App)StarDefinition.CODEC.listOf().fieldOf(STARS).forGetter(constellation -> new ArrayList())).apply((Applicative)instance, Constellation::new));

    public Constellation() {
    }

    public Constellation(Optional<SpaceObject.ParentInfo> parentLocation, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, Optional<class_2960> starTexture, List<StarDefinition> stars) {
        super(parentLocation, coords, axisRotation);
        this.starTexture = starTexture.orElse(null);
        block4: for (StarDefinition star : stars) {
            switch (StarField.LevelOfDetail.fromDistance(star.maxVisibleDistance())) {
                case LOD1: {
                    this.lod1stars.add(star);
                    continue block4;
                }
                case LOD2: {
                    this.lod2stars.add(star);
                    continue block4;
                }
            }
            this.lod3stars.add(star);
        }
    }

    public void relativeStars() {
        for (StarDefinition star : this.lod1stars) {
            star.offsetCoords(this.coords);
        }
        for (StarDefinition star : this.lod2stars) {
            star.offsetCoords(this.coords);
        }
        for (StarDefinition star : this.lod3stars) {
            star.offsetCoords(this.coords);
        }
    }

    @Nullable
    public class_2960 getStarTexture() {
        return this.starTexture;
    }

    public ArrayList<StarDefinition> lod1stars() {
        return this.lod1stars;
    }

    public ArrayList<StarDefinition> lod2stars() {
        return this.lod2stars;
    }

    public ArrayList<StarDefinition> lod3stars() {
        return this.lod3stars;
    }

    public boolean hasStarField() {
        return this.parent instanceof StarField;
    }

    private static class_2487 serializeLODTypes(ArrayList<StarDefinition> lodTypes) {
        class_2487 starTypesTag = new class_2487();
        for (int i = 0; i < lodTypes.size(); ++i) {
            starTypesTag.method_10566("star_definition_" + i, (class_2520)lodTypes.get(i).serializeNBT());
        }
        return starTypesTag;
    }

    private static ArrayList<StarDefinition> getLODTypes(class_2487 tag, String key) {
        ArrayList<StarDefinition> lodTypes;
        if (tag.method_10545(key)) {
            lodTypes = new ArrayList<StarDefinition>();
            class_2487 starTypesTag = tag.method_10562(key);
            for (int i = 0; i < starTypesTag.method_10546(); ++i) {
                StarDefinition starDefinition = new StarDefinition();
                starDefinition.deserializeNBT(starTypesTag.method_10562("star_definition_" + i));
                lodTypes.add(starDefinition);
            }
        } else {
            lodTypes = null;
        }
        return lodTypes;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = super.serializeNBT();
        if (this.lod1stars != null) {
            tag.method_10566(LOD1_STARS, (class_2520)Constellation.serializeLODTypes(this.lod1stars));
        }
        if (this.lod2stars != null) {
            tag.method_10566(LOD2_STARS, (class_2520)Constellation.serializeLODTypes(this.lod2stars));
        }
        if (this.lod3stars != null) {
            tag.method_10566(LOD3_STARS, (class_2520)Constellation.serializeLODTypes(this.lod3stars));
        }
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        this.lod1stars = Constellation.getLODTypes(tag, LOD1_STARS);
        this.lod2stars = Constellation.getLODTypes(tag, LOD2_STARS);
        this.lod3stars = Constellation.getLODTypes(tag, LOD3_STARS);
    }

    public static class StarDefinition
    implements ISerializable {
        public static final String RGB = "rgb";
        public static final String SIZE = "size";
        public static final String ROTATION = "rotation";
        public static final String BRIGHTNESS = "brightness";
        public static final String MAX_VISIBLE_DISTANCE = "max_visible_distance";
        private SpaceCoords coords;
        private Color.IntRGB rgb;
        private short brightness;
        private float size;
        private double rotation;
        private long maxVisibleDistance;
        public static final Codec<StarDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(starDefinition -> Either.left((Object)starDefinition.coords)), (App)Color.IntRGB.CODEC.fieldOf(RGB).forGetter(starDefinition -> starDefinition.rgb), (App)Codec.SHORT.fieldOf(BRIGHTNESS).forGetter(starDefinition -> starDefinition.brightness), (App)Codec.FLOAT.fieldOf(SIZE).forGetter(starDefinition -> Float.valueOf(starDefinition.size)), (App)Codec.DOUBLE.fieldOf(ROTATION).forGetter(starDefinition -> starDefinition.rotation), (App)Codec.LONG.optionalFieldOf(MAX_VISIBLE_DISTANCE, (Object)Long.MAX_VALUE).forGetter(starDefinition -> starDefinition.maxVisibleDistance)).apply((Applicative)instance, StarDefinition::new));

        public StarDefinition() {
        }

        public StarDefinition(Either<SpaceCoords, StellarCoordinates.Equatorial> coords, Color.IntRGB rgb, short brightness, float size, double rotation, long maxVisibleDistance) {
            this.coords = coords.left().isPresent() ? (SpaceCoords)coords.left().get() : ((StellarCoordinates.Equatorial)coords.right().get()).toGalactic().toSpaceCoords();
            this.rgb = rgb;
            this.brightness = brightness;
            this.size = size;
            this.rotation = Math.toRadians(rotation);
            this.maxVisibleDistance = maxVisibleDistance;
        }

        public void offsetCoords(SpaceCoords offset) {
            this.coords = this.coords.add(offset);
        }

        public SpaceCoords coords() {
            return this.coords;
        }

        public Color.IntRGB rgb() {
            return this.rgb;
        }

        public short brightness() {
            return this.brightness;
        }

        public float size() {
            return this.size;
        }

        public double rotation() {
            return this.rotation;
        }

        public long maxVisibleDistance() {
            return this.maxVisibleDistance;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10566("coords", (class_2520)this.coords.serializeNBT());
            tag.method_10566(RGB, (class_2520)this.rgb.serializeNBT());
            tag.method_10575(BRIGHTNESS, this.brightness);
            tag.method_10548(SIZE, this.size);
            tag.method_10549(ROTATION, this.rotation);
            tag.method_10544(MAX_VISIBLE_DISTANCE, this.maxVisibleDistance);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            this.coords = new SpaceCoords();
            this.coords.deserializeNBT(tag.method_10562("coords"));
            this.rgb = new Color.IntRGB();
            this.rgb.deserializeNBT(tag.method_10562(RGB));
            this.brightness = tag.method_10568(BRIGHTNESS);
            this.size = tag.method_10583(SIZE);
            this.rotation = tag.method_10574(ROTATION);
            this.maxVisibleDistance = tag.method_10537(MAX_VISIBLE_DISTANCE);
        }
    }
}

