/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.ISerializable;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;
import org.jetbrains.annotations.Nullable;

public class StarField
extends SpaceObject {
    public static final long LOD_DISTANCE_HIGH = 10000000L;
    public static final long LOD_DISTANCE_MEDIUM = 5000000L;
    public static final long LOD_DISTANCE_LOW = 0L;
    public static final class_2960 DEFAULT_STAR_TEXTURE = class_2960.method_60655((String)"stellarview", (String)"textures/environment/star.png");
    public static final class_2960 DEFAULT_DUST_CLOUD_TEXTURE = class_2960.method_60655((String)"stellarview", (String)"textures/environment/dust_cloud.png");
    public static final String DUST_CLOUDS = "dust_clouds";
    public static final String DUST_CLOUD_INFO = "dust_cloud_info";
    public static final String DUST_CLOUD_TEXTURE = "dust_cloud_texture";
    public static final String CLUMP_DUST_CLOUDS_IN_CENTER = "clump_dust_clouds_in_center";
    public static final String DUST_CLOUD_STRETCH = "dust_cloud_stretch";
    public static final String STARS = "stars";
    public static final String STAR_INFO = "star_info";
    public static final String STAR_TEXTURE = "star_texture";
    public static final String CLUMP_STARS_IN_CENTER = "clump_stars_in_center";
    public static final String STAR_STRETCH = "star_stretch";
    public static final String SEED = "seed";
    public static final String DIAMETER_LY = "diameter_ly";
    public static final String SPIRAL_ARMS = "spiral_arms";
    protected int dustClouds;
    protected class_2960 dustCloudInfo;
    protected class_2960 dustCloudTexture;
    protected boolean clumpDustCloudsInCenter;
    protected Stretch dustCloudStretch;
    protected int stars;
    protected class_2960 starInfo;
    protected class_2960 starTexture;
    protected boolean clumpStarsInCenter;
    protected Stretch starStretch;
    protected long seed;
    protected int diameter;
    protected ArrayList<SpiralArm> spiralArms;
    public static final Codec<StarField> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.ParentInfo.CODEC.optionalFieldOf("parent").forGetter(SpaceObject::getParentInfo), (App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(object -> Either.left((Object)object.getCoords())), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(SpaceObject::getAxisRotation), (App)Codec.intRange((int)0, (int)4000).optionalFieldOf(DUST_CLOUDS, (Object)0).forGetter(StarField::getDustClouds), (App)class_2960.field_25139.optionalFieldOf(DUST_CLOUD_INFO).forGetter(starField -> Optional.ofNullable(starField.dustCloudInfo)), (App)class_2960.field_25139.optionalFieldOf(DUST_CLOUD_TEXTURE, (Object)DEFAULT_DUST_CLOUD_TEXTURE).forGetter(StarField::getDustCloudTexture), (App)Codec.BOOL.optionalFieldOf(CLUMP_DUST_CLOUDS_IN_CENTER, (Object)true).forGetter(StarField::clumpDustCloudsInCenter), (App)Stretch.CODEC.optionalFieldOf(DUST_CLOUD_STRETCH, (Object)Stretch.DEFAULT_STRETCH).forGetter(StarField::dustCloudStretch), (App)Codec.intRange((int)0, (int)30000).fieldOf(STARS).forGetter(StarField::getStars), (App)class_2960.field_25139.optionalFieldOf(STAR_INFO).forGetter(starField -> Optional.ofNullable(starField.starInfo)), (App)class_2960.field_25139.optionalFieldOf(STAR_TEXTURE, (Object)DEFAULT_STAR_TEXTURE).forGetter(starField -> starField.starTexture), (App)Codec.BOOL.optionalFieldOf(CLUMP_STARS_IN_CENTER, (Object)true).forGetter(StarField::clumpStarsInCenter), (App)Stretch.CODEC.optionalFieldOf(STAR_STRETCH, (Object)Stretch.DEFAULT_STRETCH).forGetter(StarField::starStretch), (App)Codec.LONG.fieldOf(SEED).forGetter(StarField::getSeed), (App)Codec.INT.fieldOf(DIAMETER_LY).forGetter(StarField::getDiameter), (App)SpiralArm.CODEC.listOf().optionalFieldOf(SPIRAL_ARMS, new ArrayList()).forGetter(starField -> starField.spiralArms)).apply((Applicative)instance, StarField::new));

    public StarField() {
    }

    public StarField(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, int dustClouds, Optional<class_2960> dustCloudInfo, class_2960 dustCloudTexture, boolean clumpDustCloudsInCenter, Stretch dustCloudStretch, int stars, Optional<class_2960> starInfo, class_2960 starTexture, boolean clumpStarsInCenter, Stretch starStretch, long seed, int diameter, List<SpiralArm> spiralArms) {
        super(parent, coords, axisRotation);
        this.dustClouds = dustClouds;
        this.dustCloudInfo = dustCloudInfo.isPresent() ? dustCloudInfo.get() : null;
        this.dustCloudTexture = dustCloudTexture;
        this.clumpDustCloudsInCenter = clumpDustCloudsInCenter;
        this.dustCloudStretch = dustCloudStretch;
        this.stars = stars;
        this.starInfo = starInfo.isPresent() ? starInfo.get() : null;
        this.starTexture = starTexture;
        this.clumpStarsInCenter = clumpStarsInCenter;
        this.starStretch = starStretch;
        this.seed = seed;
        this.diameter = diameter;
        this.spiralArms = new ArrayList<SpiralArm>(spiralArms);
    }

    public int getDustClouds() {
        return this.dustClouds;
    }

    @Nullable
    public class_2960 getDustCloudInfo() {
        return this.dustCloudInfo;
    }

    public class_2960 getDustCloudTexture() {
        return this.dustCloudTexture;
    }

    @Nullable
    public class_2960 getStarInfo() {
        return this.starInfo;
    }

    public boolean clumpDustCloudsInCenter() {
        return this.clumpDustCloudsInCenter;
    }

    public Stretch dustCloudStretch() {
        return this.dustCloudStretch;
    }

    public class_2960 getStarTexture() {
        return this.starTexture;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public int getStars() {
        return this.stars;
    }

    public boolean clumpStarsInCenter() {
        return this.clumpStarsInCenter;
    }

    public Stretch starStretch() {
        return this.starStretch;
    }

    public List<SpiralArm> getSpiralArms() {
        return this.spiralArms;
    }

    public SpiralArm getSpiralArm(int armIndex) {
        if (armIndex < 0 || armIndex >= this.spiralArms.size()) {
            return null;
        }
        return this.spiralArms.get(armIndex);
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = super.serializeNBT();
        tag.method_10569(DUST_CLOUDS, this.dustClouds);
        tag.method_10582(DUST_CLOUD_TEXTURE, this.dustCloudTexture.toString());
        if (this.dustCloudInfo != null) {
            tag.method_10582(DUST_CLOUD_INFO, this.dustCloudInfo.toString());
        }
        tag.method_10556(CLUMP_DUST_CLOUDS_IN_CENTER, this.clumpDustCloudsInCenter);
        tag.method_10566(DUST_CLOUD_STRETCH, (class_2520)this.dustCloudStretch.serializeNBT());
        tag.method_10569(STARS, this.stars);
        tag.method_10582(STAR_TEXTURE, this.starTexture.toString());
        if (this.starInfo != null) {
            tag.method_10582(STAR_INFO, this.starInfo.toString());
        }
        tag.method_10556(CLUMP_STARS_IN_CENTER, this.clumpStarsInCenter);
        tag.method_10566(STAR_STRETCH, (class_2520)this.starStretch.serializeNBT());
        tag.method_10544(SEED, this.seed);
        tag.method_10569(DIAMETER_LY, this.diameter);
        class_2487 armsTag = new class_2487();
        for (int i = 0; i < this.spiralArms.size(); ++i) {
            armsTag.method_10566("spiral_arm_" + i, (class_2520)this.spiralArms.get(i).serializeNBT());
        }
        tag.method_10566(SPIRAL_ARMS, (class_2520)armsTag);
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 tag) {
        super.deserializeNBT(tag);
        this.dustClouds = tag.method_10550(DUST_CLOUDS);
        this.dustCloudTexture = class_2960.method_12829((String)tag.method_10558(DUST_CLOUD_TEXTURE));
        this.dustCloudInfo = tag.method_10545(DUST_CLOUD_INFO) ? class_2960.method_12829((String)tag.method_10558(DUST_CLOUD_INFO)) : null;
        this.clumpDustCloudsInCenter = tag.method_10577(CLUMP_DUST_CLOUDS_IN_CENTER);
        this.dustCloudStretch = new Stretch();
        this.dustCloudStretch.deserializeNBT(tag.method_10562(DUST_CLOUD_STRETCH));
        this.stars = tag.method_10550(STARS);
        this.starTexture = class_2960.method_12829((String)tag.method_10558(STAR_TEXTURE));
        this.starInfo = tag.method_10545(STAR_INFO) ? class_2960.method_12829((String)tag.method_10558(STAR_INFO)) : null;
        this.clumpStarsInCenter = tag.method_10577(CLUMP_STARS_IN_CENTER);
        this.starStretch = new Stretch();
        this.starStretch.deserializeNBT(tag.method_10562(STAR_STRETCH));
        this.seed = tag.method_10537(SEED);
        this.diameter = tag.method_10550(DIAMETER_LY);
        this.spiralArms = new ArrayList();
        class_2487 armsTag = tag.method_10562(SPIRAL_ARMS);
        for (String key : armsTag.method_10541()) {
            SpiralArm arm = new SpiralArm();
            arm.deserializeNBT(armsTag.method_10562(key));
            this.spiralArms.add(arm);
        }
    }

    public static class Stretch
    implements ISerializable {
        public static final String X_STRETCH = "x";
        public static final String Y_STRETCH = "y";
        public static final String Z_STRETCH = "z";
        protected double xStretch;
        protected double yStretch;
        protected double zStretch;
        public static final Stretch DEFAULT_STRETCH = new Stretch();
        public static final Codec<Stretch> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf(X_STRETCH, (Object)1.0).forGetter(stretch -> stretch.xStretch), (App)Codec.DOUBLE.optionalFieldOf(Y_STRETCH, (Object)1.0).forGetter(stretch -> stretch.yStretch), (App)Codec.DOUBLE.optionalFieldOf(Z_STRETCH, (Object)1.0).forGetter(stretch -> stretch.zStretch)).apply((Applicative)instance, Stretch::new));

        public Stretch(double xStretch, double yStretch, double zStretch) {
            this.xStretch = xStretch;
            this.yStretch = yStretch;
            this.zStretch = zStretch;
        }

        public Stretch() {
            this(1.0, 1.0, 1.0);
        }

        public double xStretch() {
            return this.xStretch;
        }

        public double yStretch() {
            return this.yStretch;
        }

        public double zStretch() {
            return this.zStretch;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10549(X_STRETCH, this.xStretch);
            tag.method_10549(Y_STRETCH, this.yStretch);
            tag.method_10549(Z_STRETCH, this.zStretch);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            this.xStretch = tag.method_10574(X_STRETCH);
            this.yStretch = tag.method_10574(Y_STRETCH);
            this.zStretch = tag.method_10574(Z_STRETCH);
        }
    }

    public static class SpiralArm
    implements ISerializable {
        public static final String STARS = "stars";
        public static final String ARM_ROTATION = "arm_rotation";
        public static final String ARM_LENGTH = "arm_length";
        public static final String ARM_THICKNESS = "arm_thickness";
        public static final String CLUMP_STARS_IN_CENTER = "clump_stars_in_center";
        @Nullable
        protected class_2960 dustCloudInfo;
        protected int armDustClouds;
        protected int armStars;
        protected double armRotation;
        protected double armLength;
        protected double armThickness;
        protected boolean clumpStarsInCenter;
        protected boolean clumpDustCloudsInCenter;
        public static final Codec<SpiralArm> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)4000).optionalFieldOf(StarField.DUST_CLOUDS, (Object)0).forGetter(SpiralArm::armDustClouds), (App)class_2960.field_25139.optionalFieldOf(StarField.DUST_CLOUD_INFO).forGetter(arm -> Optional.ofNullable(arm.dustCloudInfo)), (App)Codec.intRange((int)0, (int)30000).fieldOf("stars").forGetter(SpiralArm::armStars), (App)Codec.DOUBLE.fieldOf(ARM_ROTATION).forGetter(SpiralArm::armRotation), (App)Codec.DOUBLE.fieldOf(ARM_LENGTH).forGetter(SpiralArm::armLength), (App)Codec.DOUBLE.fieldOf(ARM_THICKNESS).forGetter(SpiralArm::armThickness), (App)Codec.BOOL.optionalFieldOf("clump_stars_in_center", (Object)true).forGetter(SpiralArm::clumpStarsInCenter)).apply((Applicative)instance, SpiralArm::new));

        public SpiralArm() {
        }

        public SpiralArm(int armDustClouds, Optional<class_2960> dustCloudInfo, int armStars, double armRotationDegrees, double armLength, double armThickness, boolean clumpStarsInCenter) {
            this.armDustClouds = armDustClouds;
            this.dustCloudInfo = dustCloudInfo.isPresent() ? dustCloudInfo.get() : null;
            this.armStars = armStars;
            this.armRotation = Math.toRadians(armRotationDegrees);
            this.armLength = armLength;
            this.armThickness = armThickness;
            this.clumpStarsInCenter = clumpStarsInCenter;
        }

        public int armDustClouds() {
            return this.armDustClouds;
        }

        @Nullable
        public class_2960 dustCloudInfo() {
            return this.dustCloudInfo;
        }

        public int armStars() {
            return this.armStars;
        }

        public double armRotation() {
            return this.armRotation;
        }

        public double armLength() {
            return this.armLength;
        }

        public double armThickness() {
            return this.armThickness;
        }

        public boolean clumpStarsInCenter() {
            return this.clumpStarsInCenter;
        }

        public boolean clumpDustCloudsInCenter() {
            return this.clumpDustCloudsInCenter;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10569(StarField.DUST_CLOUDS, this.armDustClouds);
            if (this.dustCloudInfo != null) {
                tag.method_10582(StarField.DUST_CLOUD_INFO, this.dustCloudInfo.toString());
            }
            tag.method_10569("stars", this.armStars);
            tag.method_10549(ARM_ROTATION, this.armRotation);
            tag.method_10549(ARM_LENGTH, this.armLength);
            tag.method_10549(ARM_THICKNESS, this.armThickness);
            tag.method_10556("clump_stars_in_center", this.clumpStarsInCenter);
            tag.method_10556(StarField.CLUMP_DUST_CLOUDS_IN_CENTER, this.clumpDustCloudsInCenter);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            this.armDustClouds = tag.method_10550(StarField.DUST_CLOUDS);
            this.dustCloudInfo = tag.method_10545(StarField.DUST_CLOUD_INFO) ? class_2960.method_12829((String)tag.method_10558(StarField.DUST_CLOUD_INFO)) : null;
            this.armStars = tag.method_10550("stars");
            this.armRotation = tag.method_10574(ARM_ROTATION);
            this.armLength = tag.method_10574(ARM_LENGTH);
            this.armThickness = tag.method_10574(ARM_THICKNESS);
            this.clumpStarsInCenter = tag.method_10577("clump_stars_in_center");
            this.clumpDustCloudsInCenter = tag.method_10577(StarField.CLUMP_DUST_CLOUDS_IN_CENTER);
        }
    }

    public static enum LevelOfDetail {
        LOD1(225, 10000000L),
        LOD2(190, 5000000L),
        LOD3(0, 0L);

        short minBrightness;
        long minDistanceSquared;

        private LevelOfDetail(short minBrightness, long minDistance) {
            this.minBrightness = minBrightness;
            this.minDistanceSquared = minDistance * minDistance;
        }

        public static LevelOfDetail fromBrightness(short brightness) {
            if (brightness < LevelOfDetail.LOD2.minBrightness) {
                return LOD3;
            }
            if (brightness < LevelOfDetail.LOD1.minBrightness) {
                return LOD2;
            }
            return LOD1;
        }

        public static LevelOfDetail fromDistance(long distance) {
            long distanceSquared = distance * distance;
            if (distanceSquared >= LevelOfDetail.LOD1.minDistanceSquared) {
                return LOD1;
            }
            if (distanceSquared >= LevelOfDetail.LOD2.minDistanceSquared) {
                return LOD2;
            }
            return LOD3;
        }

        public static LevelOfDetail fromDistance(SpaceCoords difference) {
            long distanceSquared = difference.lyDistanceSquared();
            if (distanceSquared >= LevelOfDetail.LOD1.minDistanceSquared) {
                return LOD1;
            }
            if (distanceSquared >= LevelOfDetail.LOD2.minDistanceSquared) {
                return LOD2;
            }
            return LOD3;
        }
    }
}

