/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client;

import java.util.HashMap;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import org.jetbrains.annotations.Nullable;

public class SpaceObjectRenderers {
    private static final HashMap<Class<? extends SpaceObject>, SpaceObjectConstructor> RENDERERS = new HashMap();

    public static <T extends SpaceObject, U extends SpaceObjectRenderer<T>> void register(Class<T> objectClass, SpaceObjectConstructor<T, U> constructor) {
        if (RENDERERS.containsKey(objectClass)) {
            throw new IllegalStateException("Duplicate registration for " + objectClass.getName());
        }
        RENDERERS.put(objectClass, constructor);
    }

    @Nullable
    public static SpaceObjectRenderer constructObjectRenderer(SpaceObject object) {
        if (RENDERERS.containsKey(object.getClass())) {
            return RENDERERS.get(object.getClass()).create(object);
        }
        return null;
    }

    public static interface SpaceObjectConstructor<T extends SpaceObject, U extends SpaceObjectRenderer> {
        public U create(T var1);
    }
}

