/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import net.povstalec.stellarview.api.common.space_objects.TexturedObject;
import net.povstalec.stellarview.client.render.LightEffects;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.SphericalCoords;
import net.povstalec.stellarview.common.util.TextureLayer;
import net.povstalec.stellarview.common.util.UV;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class TexturedObjectRenderer<T extends TexturedObject>
extends SpaceObjectRenderer<T> {
    public static final float DEFAULT_DISTANCE = 100.0f;

    public TexturedObjectRenderer(T texturedObject) {
        super(texturedObject);
    }

    @Override
    public void render(ViewCenter viewCenter, class_638 level, float partialTicks, Matrix4f modelViewMatrix, class_4184 camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, class_289 tesselator, Vector3f parentVector, AxisRotation parentRotation) {
        Vector3f positionVector = this.getPosition(viewCenter, parentRotation, viewCenter.ticks(), partialTicks).add((Vector3fc)parentVector);
        SpaceCoords coords = ((TexturedObject)this.renderedObject).getCoords().add(positionVector);
        SphericalCoords sphericalCoords = coords.skyPosition(level, viewCenter, partialTicks, true);
        this.lastDistance = sphericalCoords.r;
        sphericalCoords.r = 100.0;
        double childRenderDistance = ((TexturedObject)this.renderedObject).getFadeOutHandler().getMaxChildRenderDistance().toKm();
        if (childRenderDistance > this.lastDistance) {
            for (SpaceObjectRenderer child : this.children) {
                if (!(child.lastDistance >= this.lastDistance)) continue;
                child.render(viewCenter, level, partialTicks, modelViewMatrix, camera, projectionMatrix, isFoggy, setupFog, tesselator, positionVector, this.axisRotation());
            }
        }
        if (!viewCenter.objectEquals(this) && ((TexturedObject)this.renderedObject).getFadeOutHandler().getFadeOutEndDistance().toKm() > this.lastDistance) {
            this.renderTextureLayers(viewCenter, level, camera, tesselator, modelViewMatrix, sphericalCoords, viewCenter.ticks(), this.lastDistance, partialTicks);
        }
        if (childRenderDistance > this.lastDistance) {
            for (SpaceObjectRenderer child : this.children) {
                if (!(child.lastDistance < this.lastDistance)) continue;
                child.render(viewCenter, level, partialTicks, modelViewMatrix, camera, projectionMatrix, isFoggy, setupFog, tesselator, positionVector, this.axisRotation());
            }
        }
    }

    public static void renderOnSphere(Color.FloatRGBA rgba, Color.FloatRGBA secondaryRGBA, class_2960 texture, UV.Quad uv, class_638 level, class_4184 camera, class_289 tesselator, Matrix4f lastMatrix, SphericalCoords sphericalCoords, long ticks, double distance, float partialTicks, float brightness, float size, float rotation, boolean shouldBlend) {
        Vector3f corner00 = new Vector3f(size, 100.0f, size);
        Vector3f corner10 = new Vector3f(-size, 100.0f, size);
        Vector3f corner11 = new Vector3f(-size, 100.0f, -size);
        Vector3f corner01 = new Vector3f(size, 100.0f, -size);
        Quaterniond quaternionX = new Quaterniond().rotateY(sphericalCoords.theta);
        quaternionX.mul((Quaterniondc)new Quaterniond().rotateX(sphericalCoords.phi));
        quaternionX.mul((Quaterniondc)new Quaterniond().rotateY((double)rotation));
        quaternionX.transform(corner00);
        quaternionX.transform(corner10);
        quaternionX.transform(corner11);
        quaternionX.transform(corner01);
        if (shouldBlend) {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        } else {
            RenderSystem.defaultBlendFunc();
        }
        RenderSystem.setShaderColor((float)(rgba.red() * secondaryRGBA.red()), (float)(rgba.green() * secondaryRGBA.green()), (float)(rgba.blue() * secondaryRGBA.blue()), (float)(brightness * rgba.alpha() * secondaryRGBA.alpha()));
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        class_287 bufferbuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(lastMatrix, corner00.x, corner00.y, corner00.z).method_22913(uv.topRight().u(ticks), uv.topRight().v(ticks));
        bufferbuilder.method_22918(lastMatrix, corner10.x, corner10.y, corner10.z).method_22913(uv.bottomRight().u(ticks), uv.bottomRight().v(ticks));
        bufferbuilder.method_22918(lastMatrix, corner11.x, corner11.y, corner11.z).method_22913(uv.bottomLeft().u(ticks), uv.bottomLeft().v(ticks));
        bufferbuilder.method_22918(lastMatrix, corner01.x, corner01.y, corner01.z).method_22913(uv.topLeft().u(ticks), uv.topLeft().v(ticks));
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
        RenderSystem.defaultBlendFunc();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void renderTextureLayer(TextureLayer textureLayer, ViewCenter viewCenter, class_638 level, class_4184 camera, class_289 tesselator, Matrix4f lastMatrix, SphericalCoords sphericalCoords, double fade, long ticks, double distance, float partialTicks) {
        if (textureLayer.rgba().alpha() <= 0.0f) {
            return;
        }
        TexturedObject cfr_ignored_0 = (TexturedObject)this.renderedObject;
        float size = (float)textureLayer.mulSize(TexturedObject.distanceSize(distance));
        if ((double)size < textureLayer.minSize()) {
            if (!textureLayer.clampAtMinSize()) return;
            size = (float)textureLayer.minSize();
        } else if ((double)size > textureLayer.maxSize()) {
            if (!textureLayer.clampAtMaxSize()) return;
            size = (float)textureLayer.maxSize();
        }
        TexturedObjectRenderer.renderOnSphere(textureLayer.rgba(), Color.FloatRGBA.DEFAULT, textureLayer.texture(), textureLayer.uv(), level, camera, tesselator, lastMatrix, sphericalCoords, ticks, distance, partialTicks, LightEffects.dayBrightness(viewCenter, size, ticks, level, camera, partialTicks) * (float)fade, size, (float)textureLayer.rotation(), textureLayer.shoulBlend());
    }

    protected void renderTextureLayers(ViewCenter viewCenter, class_638 level, class_4184 camera, class_289 tesselator, Matrix4f lastMatrix, SphericalCoords sphericalCoords, long ticks, double distance, float partialTicks) {
        double fade = ((TexturedObject)this.renderedObject).fadeOut(distance);
        if (fade <= 0.0) {
            return;
        }
        RenderSystem.setShader(class_757::method_34542);
        for (TextureLayer textureLayer : ((TexturedObject)this.renderedObject).getTextureLayers()) {
            this.renderTextureLayer(textureLayer, viewCenter, level, camera, tesselator, lastMatrix, sphericalCoords, fade, ticks, distance, partialTicks);
        }
    }
}

