/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects.resourcepack;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_758;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Constellation;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.client.util.StarData;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.SpaceCoords;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ConstellationRenderer<T extends Constellation>
extends SpaceObjectRenderer<T> {
    protected boolean hasTexture = GeneralConfig.textured_stars.get();
    protected StarData starData;

    public ConstellationRenderer(T constellation) {
        super(constellation);
    }

    public class_2960 getStarTexture() {
        if (((Constellation)this.renderedObject()).getStarTexture() != null) {
            return ((Constellation)this.renderedObject()).getStarTexture();
        }
        return StarField.DEFAULT_STAR_TEXTURE;
    }

    public boolean shouldRender() {
        return !((Constellation)this.renderedObject()).hasStarField() || ((Constellation)this.renderedObject()).getStarTexture() != null;
    }

    public boolean requiresReset() {
        return this.hasTexture != GeneralConfig.textured_stars.get();
    }

    public void reset() {
        if (this.starData != null) {
            this.starData.reset();
        }
    }

    protected void generateStars(StarData.LOD lod, ArrayList<Constellation.StarDefinition> definedStars) {
        for (Constellation.StarDefinition star : definedStars) {
            lod.newStar(star, this.spaceCoords());
        }
    }

    protected void setStars() {
        this.starData = new StarData(){

            @Override
            protected StarData.LOD newStars(StarField.LevelOfDetail levelOfDetail) {
                int stars;
                ArrayList<Constellation.StarDefinition> definedStars = switch (levelOfDetail) {
                    case StarField.LevelOfDetail.LOD1 -> {
                        stars = ((Constellation)ConstellationRenderer.this.renderedObject).lod1stars().size();
                        yield ((Constellation)ConstellationRenderer.this.renderedObject).lod1stars();
                    }
                    case StarField.LevelOfDetail.LOD2 -> {
                        stars = ((Constellation)ConstellationRenderer.this.renderedObject).lod2stars().size();
                        yield ((Constellation)ConstellationRenderer.this.renderedObject).lod2stars();
                    }
                    default -> {
                        stars = ((Constellation)ConstellationRenderer.this.renderedObject).lod3stars().size();
                        yield ((Constellation)ConstellationRenderer.this.renderedObject).lod3stars();
                    }
                };
                StarData.LOD lod = new StarData.LOD(stars);
                ConstellationRenderer.this.generateStars(lod, definedStars);
                return lod;
            }
        };
    }

    @Override
    public void render(ViewCenter viewCenter, class_638 level, float partialTicks, Matrix4f modelViewMatrix, class_4184 camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, class_289 tesselator, Vector3f parentVector, AxisRotation parentRotation) {
        SpaceCoords difference = viewCenter.getCoords().sub(this.spaceCoords());
        if (this.starData == null) {
            this.setStars();
        } else if (this.requiresReset()) {
            this.hasTexture = GeneralConfig.textured_stars.get();
            this.starData.reset();
        }
        if (!GeneralConfig.disable_stars.get() && viewCenter.starBrightness() > 0.0f) {
            Matrix4f transformedModelView = new Matrix4f((Matrix4fc)modelViewMatrix);
            if (this.hasTexture) {
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)viewCenter.starBrightness());
            if (this.hasTexture) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.getStarTexture());
            }
            class_758.method_23792();
            Quaternionf q = SpaceCoords.getQuaternionf(level, viewCenter, partialTicks);
            transformedModelView.rotate((Quaternionfc)q);
            this.starData.renderStars(StarField.LevelOfDetail.fromDistance(difference), transformedModelView, projectionMatrix, difference, viewCenter.isStatic(), this.hasTexture);
            setupFog.run();
        }
        for (SpaceObjectRenderer child : this.children) {
            child.render(viewCenter, level, partialTicks, modelViewMatrix, camera, projectionMatrix, isFoggy, setupFog, tesselator, parentVector, new AxisRotation(0.0, 0.0, 0.0));
        }
    }
}

