/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.space_objects.resourcepack;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_289;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Star;
import net.povstalec.stellarview.client.render.LightEffects;
import net.povstalec.stellarview.client.render.space_objects.StarLikeRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.util.Color;
import net.povstalec.stellarview.common.util.SphericalCoords;
import net.povstalec.stellarview.common.util.TextureLayer;
import org.joml.Matrix4f;

public class StarRenderer<T extends Star>
extends StarLikeRenderer<T> {
    public StarRenderer(T star) {
        super(star);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void renderTextureLayer(TextureLayer textureLayer, ViewCenter viewCenter, class_638 level, class_4184 camera, class_289 tesselator, Matrix4f lastMatrix, SphericalCoords sphericalCoords, double fade, long ticks, double distance, float partialTicks) {
        double lyDistance = distance / 9.4607304725812E12;
        Color.FloatRGBA starRGBA = ((Star)this.renderedObject).supernovaRGBA(ticks, lyDistance);
        if (starRGBA.alpha() <= 0.0f || textureLayer.rgba().alpha() <= 0.0f) {
            return;
        }
        Star cfr_ignored_0 = (Star)this.renderedObject;
        float size = (float)textureLayer.mulSize(Star.distanceSize(distance));
        if ((double)size < textureLayer.minSize()) {
            if (!textureLayer.clampAtMinSize()) return;
            size = (float)textureLayer.minSize();
            size = ((Star)this.renderedObject).starSize(size, lyDistance);
        } else if ((double)size > textureLayer.maxSize()) {
            if (!textureLayer.clampAtMaxSize()) return;
            size = (float)textureLayer.maxSize();
        }
        if (((Star)this.renderedObject).isSupernova()) {
            size = ((Star)this.renderedObject).supernovaSize(size, ticks, lyDistance);
        }
        StarRenderer.renderOnSphere(textureLayer.rgba(), starRGBA, textureLayer.texture(), textureLayer.uv(), level, camera, tesselator, lastMatrix, sphericalCoords, ticks, distance, partialTicks, LightEffects.starDayBrightness(viewCenter, size, ticks, level, camera, partialTicks) * (float)fade, size, (float)textureLayer.rotation() + ((Star)this.renderedObject).rotation(ticks), textureLayer.shoulBlend());
    }

    @Override
    protected void renderTextureLayers(ViewCenter viewCenter, class_638 level, class_4184 camera, class_289 tesselator, Matrix4f lastMatrix, SphericalCoords sphericalCoords, long ticks, double distance, float partialTicks) {
        double fade = ((Star)this.renderedObject).fadeOut(distance);
        if (fade <= 0.0 || ((Star)this.renderedObject).isSupernova() && ((Star)this.renderedObject).supernovaInfo().supernovaEnded(ticks)) {
            return;
        }
        RenderSystem.setShader(class_757::method_34542);
        for (TextureLayer textureLayer : ((Star)this.renderedObject).getTextureLayers()) {
            this.renderTextureLayer(textureLayer, viewCenter, level, camera, tesselator, lastMatrix, sphericalCoords, fade, ticks, distance, partialTicks);
        }
    }
}

