/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.resourcepack;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.api.client.events.StellarViewEvents;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.api.common.space_objects.distinct.Luna;
import net.povstalec.stellarview.api.common.space_objects.distinct.Sol;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.BlackHole;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Constellation;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Moon;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Nebula;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Planet;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.Star;
import net.povstalec.stellarview.api.common.space_objects.resourcepack.StarField;
import net.povstalec.stellarview.client.SpaceObjectRenderers;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.StellarViewEffects;
import net.povstalec.stellarview.client.render.ViewCenters;
import net.povstalec.stellarview.client.render.level.StellarViewEndEffects;
import net.povstalec.stellarview.client.render.level.StellarViewNetherEffects;
import net.povstalec.stellarview.client.render.level.StellarViewOverworldEffects;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.resourcepack.DefaultViewCenters;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.client.resourcepack.effects.MeteorEffect;
import net.povstalec.stellarview.common.util.DustCloudInfo;
import net.povstalec.stellarview.common.util.StarInfo;

public class ResourcepackReloadListener {
    public static final class_2960 REMOVE = class_2960.method_60655((String)"stellarview", (String)"remove");
    public static final String PATH = "stellarview";
    public static final String VIEW_CENTERS = "view_centers";
    public static final String CELESTIALS = "celestials";
    public static final String PLANET = "planet";
    public static final String MOON = "moon";
    public static final String STAR = "star";
    public static final String BLACK_HOLE = "black_hole";
    public static final String STAR_FIELD = "star_field";
    public static final String CONSTELLATION = "constellation";
    public static final String NEBULA = "nebula";
    public static final String EFFECTS = "effects";
    public static final String STAR_INFO = "star_info";
    public static final String DUST_CLOUD_INFO = "dust_cloud_info";
    private static final class_2960 MILKY_WAY_LOCATION = class_2960.method_60655((String)"stellarview", (String)"star_field/milky_way/milky_way");
    private static final class_2960 SOL_LOCATION = class_2960.method_60655((String)"stellarview", (String)"star/milky_way/sol");
    private static final class_2960 LUNA_LOCATION = class_2960.method_60655((String)"stellarview", (String)"moon/milky_way/sol/earth/luna");
    private static HashMap<class_2960, ViewCenter> viewCenters;
    private static HashMap<class_2960, SpaceObjectRenderer<?>> spaceObjects;
    private static HashMap<class_2960, StarInfo> starTypes;
    private static HashMap<class_2960, DustCloudInfo> dustCloudTypes;

    public static Function<String, IllegalStateException> loggedExceptionProvider(String loggedMessage) {
        return msg -> {
            IllegalStateException e = new IllegalStateException((String)msg);
            StellarView.LOGGER.error("{}", (Object)loggedMessage, (Object)e);
            return e;
        };
    }

    public static class ReloadListener
    extends class_4309 {
        public ReloadListener() {
            super(new GsonBuilder().create(), ResourcepackReloadListener.PATH);
        }

        protected void apply(Map<class_2960, JsonElement> jsonMap, class_3300 manager, class_3695 filler) {
            if (StellarViewEvents.onReload(jsonMap, manager, filler)) {
                return;
            }
            viewCenters = new HashMap();
            spaceObjects = new HashMap();
            starTypes = new HashMap();
            dustCloudTypes = new HashMap();
            for (Map.Entry<class_2960, JsonElement> jsonEntry : jsonMap.entrySet()) {
                SpaceObjectRenderer renderer;
                class_2960 location = jsonEntry.getKey();
                JsonElement element = jsonEntry.getValue();
                if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.VIEW_CENTERS)) {
                    ReloadListener.addViewCenter(viewCenters, ReloadListener.shortenPath(location, ResourcepackReloadListener.VIEW_CENTERS), element);
                    continue;
                }
                if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.EFFECTS)) {
                    if (ReloadListener.canShortenPath(location = ReloadListener.shortenPath(location, ResourcepackReloadListener.EFFECTS), ResourcepackReloadListener.STAR_INFO)) {
                        ReloadListener.addStarType(starTypes, ReloadListener.shortenPath(location, ResourcepackReloadListener.STAR_INFO), element);
                        continue;
                    }
                    if (!ReloadListener.canShortenPath(location, ResourcepackReloadListener.DUST_CLOUD_INFO)) continue;
                    ReloadListener.addDustCloudType(dustCloudTypes, ReloadListener.shortenPath(location, ResourcepackReloadListener.DUST_CLOUD_INFO), element);
                    continue;
                }
                if (!ReloadListener.canShortenPath(location, ResourcepackReloadListener.CELESTIALS)) continue;
                SpaceObject spaceObject = null;
                if (ReloadListener.canShortenPath(location = ReloadListener.shortenPath(location, ResourcepackReloadListener.CELESTIALS), ResourcepackReloadListener.PLANET)) {
                    spaceObject = ReloadListener.makePlanet(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.MOON)) {
                    spaceObject = ReloadListener.makeMoon(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.STAR)) {
                    spaceObject = ReloadListener.makeStar(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.STAR_FIELD)) {
                    spaceObject = ReloadListener.makeStarField(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.CONSTELLATION)) {
                    spaceObject = ReloadListener.makeConstellation(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.BLACK_HOLE)) {
                    spaceObject = ReloadListener.makeBlackHole(location, element);
                } else if (ReloadListener.canShortenPath(location, ResourcepackReloadListener.NEBULA)) {
                    spaceObject = ReloadListener.makeNebula(location, element);
                }
                if (spaceObject == null || ReloadListener.shouldIgnore(spaceObject) || (renderer = SpaceObjectRenderers.constructObjectRenderer(spaceObject)) == null) continue;
                spaceObjects.put(location, renderer);
            }
            if (!StellarViewEvents.onEffectsReload(starTypes, dustCloudTypes)) {
                StellarViewEffects.reset();
                StellarViewEffects.setupEffects(starTypes, dustCloudTypes);
            }
            if (!StellarViewEvents.onSpaceRendererReload(spaceObjects)) {
                SpaceRenderer.clear();
                ReloadListener.setSpaceObjects(spaceObjects);
                SpaceRenderer.setupSynodicOrbits();
            }
            if (!StellarViewEvents.onViewCenterReload(spaceObjects, viewCenters)) {
                ViewCenters.clear();
                ReloadListener.setViewCenters(spaceObjects, viewCenters);
            }
        }

        public static void addViewCenter(HashMap<class_2960, ViewCenter> viewCenters, class_2960 location, JsonElement element) {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)"view_center");
                ViewCenter viewCenter = StellarViewOverworldEffects.OVERWORLD_EFFECTS.equals((Object)location) ? (ViewCenter)DefaultViewCenters.Overworld.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse View Center")) : (StellarViewNetherEffects.NETHER_EFFECTS.equals((Object)location) ? (ViewCenter)DefaultViewCenters.Nether.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse View Center")) : (StellarViewEndEffects.END_EFFECTS.equals((Object)location) ? (ViewCenter)DefaultViewCenters.End.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse View Center")) : (ViewCenter)ViewCenter.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse View Center"))));
                viewCenters.put(location, viewCenter);
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
            }
        }

        public static void setViewCenters(HashMap<class_2960, SpaceObjectRenderer<?>> spaceObjects, HashMap<class_2960, ViewCenter> viewCenters) {
            for (Map.Entry<class_2960, ViewCenter> viewCenterEntry : viewCenters.entrySet()) {
                if (!viewCenterEntry.getValue().setViewObjectRenderer(spaceObjects)) continue;
                ViewCenters.addViewCenter(viewCenterEntry.getKey(), viewCenterEntry.getValue());
            }
        }

        public static void addStarType(HashMap<class_2960, StarInfo> starTypes, class_2960 location, JsonElement element) {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.STAR_INFO);
                StarInfo starInfo = (StarInfo)StarInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Star Info"));
                starTypes.put(location, starInfo);
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
            }
        }

        public static void addDustCloudType(HashMap<class_2960, DustCloudInfo> dustCloudTypes, class_2960 location, JsonElement element) {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.DUST_CLOUD_INFO);
                DustCloudInfo dustCloudInfo = (DustCloudInfo)DustCloudInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Dust Cloud Info"));
                dustCloudTypes.put(location, dustCloudInfo);
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
            }
        }

        public static void addMeteorType(HashMap<class_2960, MeteorEffect.MeteorType> meteorTypes, class_2960 location, JsonElement element) {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)"meteor_type");
                MeteorEffect.MeteorType meteorType = (MeteorEffect.MeteorType)MeteorEffect.MeteorType.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Meteor Type"));
                meteorTypes.put(location, meteorType);
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
            }
        }

        public static boolean shouldIgnore(SpaceObject spaceObject) {
            if (spaceObject.getParentLocation() != null) {
                return REMOVE.equals((Object)spaceObject.getParentLocation());
            }
            return false;
        }

        public static Star makeStar(class_2960 location, JsonElement element) {
            try {
                if (SOL_LOCATION.equals((Object)location)) {
                    JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.STAR);
                    Sol sol = (Sol)Sol.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Sol"));
                    SpaceRenderer.addSol(sol);
                    return sol;
                }
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.STAR);
                Star star = (Star)Star.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Star"));
                return star;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static BlackHole makeBlackHole(class_2960 location, JsonElement element) {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.BLACK_HOLE);
                BlackHole blackHole = (BlackHole)BlackHole.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Black Hole"));
                return blackHole;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static Planet makePlanet(class_2960 location, JsonElement element) {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.PLANET);
                Planet planet = (Planet)Planet.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Planet"));
                return planet;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static Moon makeMoon(class_2960 location, JsonElement element) {
            try {
                if (LUNA_LOCATION.equals((Object)location)) {
                    JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.MOON);
                    Luna luna = (Luna)Luna.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Luna"));
                    return luna;
                }
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.MOON);
                Moon moon = (Moon)Moon.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Moon"));
                return moon;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static StarField makeStarField(class_2960 location, JsonElement element) {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.STAR_FIELD);
                StarField starField = (StarField)StarField.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Star Field"));
                return starField;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static Constellation makeConstellation(class_2960 location, JsonElement element) {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.CONSTELLATION);
                Constellation constellation = (Constellation)Constellation.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Constellation"));
                return constellation;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static Nebula makeNebula(class_2960 location, JsonElement element) {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)ResourcepackReloadListener.NEBULA);
                Nebula nebula = (Nebula)Nebula.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(ResourcepackReloadListener.loggedExceptionProvider("Failed to parse Nebula"));
                return nebula;
            }
            catch (RuntimeException e) {
                StellarView.LOGGER.error("Could not load " + location.toString(), (Throwable)e);
                return null;
            }
        }

        public static void setSpaceObjects(HashMap<class_2960, SpaceObjectRenderer<?>> spaceObjects) {
            for (Map.Entry<class_2960, SpaceObjectRenderer<?>> spaceObjectEntry : spaceObjects.entrySet()) {
                SpaceObjectRenderer<?> spaceObject = spaceObjectEntry.getValue();
                Object obj = spaceObject.renderedObject();
                if (obj instanceof Sol) {
                    Sol sol = (Sol)obj;
                    SpaceRenderer.addSol(sol);
                }
                if (((SpaceObject)spaceObject.renderedObject()).getParentLocation() != null) {
                    for (Map.Entry<class_2960, SpaceObjectRenderer<?>> parentEntry : spaceObjects.entrySet()) {
                        if (!parentEntry.getKey().equals((Object)((SpaceObject)spaceObject.renderedObject()).getParentLocation())) continue;
                        parentEntry.getValue().addChild(spaceObject);
                        break;
                    }
                    if (!((SpaceObject)spaceObject.renderedObject()).getParent().isEmpty()) continue;
                    StellarView.LOGGER.error("Failed to find parent for " + spaceObject.toString());
                    continue;
                }
                SpaceRenderer.addSpaceObjectRenderer(spaceObjectEntry.getValue());
            }
            for (Map.Entry<class_2960, SpaceObjectRenderer<?>> spaceObjectEntry : spaceObjects.entrySet()) {
                spaceObjectEntry.getValue().setupSpaceObject(spaceObjectEntry.getKey(), null);
            }
        }

        private static boolean canShortenPath(class_2960 location, String shortenBy) {
            return location.method_12832().startsWith(shortenBy + "/") && location.method_12832().length() > shortenBy.length();
        }

        private static class_2960 shortenPath(class_2960 location, String shortenBy) {
            return location.method_45136(location.method_12832().substring(shortenBy.length() + 1));
        }
    }
}

