/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2487;
import net.minecraft.class_5253;
import net.povstalec.stellarview.common.util.ISerializable;

public class Color {
    public static final int MAX_INT_VALUE = 255;
    public static final int MIN_INT_VALUE = 0;
    public static final float MAX_FLOAT_VALUE = 1.0f;
    public static final float MIN_FLOAT_VALUE = 0.0f;
    public static final String RED = "red";
    public static final String GREEN = "green";
    public static final String BLUE = "blue";
    public static final String ALPHA = "alpha";

    private static void checkIntValue(int value) {
        if (value > 255) {
            throw new IllegalArgumentException("Value may not be higher than 255");
        }
        if (value < 0) {
            throw new IllegalArgumentException("Value may not be lower than 0");
        }
    }

    private static void checkFloatValue(float value) {
        if (value > 1.0f) {
            throw new IllegalArgumentException("Value may not be higher than 1.0");
        }
        if (value < 0.0f) {
            throw new IllegalArgumentException("Value may not be lower than 0.0");
        }
    }

    public static class FloatRGBA
    extends FloatRGB {
        public static final FloatRGBA DEFAULT = new FloatRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        public static final Codec<FloatRGBA> INT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf(Color.RED).forGetter(color -> (int)(color.red * 255.0f)), (App)Codec.intRange((int)0, (int)255).fieldOf(Color.GREEN).forGetter(color -> (int)(color.green * 255.0f)), (App)Codec.intRange((int)0, (int)255).fieldOf(Color.BLUE).forGetter(color -> (int)(color.blue * 255.0f)), (App)Codec.intRange((int)0, (int)255).optionalFieldOf(Color.ALPHA, (Object)255).forGetter(color -> (int)(color.alpha * 255.0f))).apply((Applicative)instance, FloatRGBA::new));
        public static final Codec<FloatRGBA> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf(Color.RED).forGetter(FloatRGB::red), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf(Color.GREEN).forGetter(FloatRGB::green), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf(Color.BLUE).forGetter(FloatRGB::blue), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf(Color.ALPHA, (Object)Float.valueOf(1.0f)).forGetter(FloatRGBA::alpha)).apply((Applicative)instance, FloatRGBA::new));
        protected float alpha;

        public FloatRGBA() {
        }

        public FloatRGBA(int argb) {
            super(argb);
            this.alpha = (float)class_5253.class_5254.method_27762((int)argb) / 255.0f;
        }

        protected FloatRGBA(int red, int green, int blue, int alpha) {
            super(red, green, blue);
            if (alpha > 255) {
                throw new IllegalArgumentException("No value may be higher than 255");
            }
            if (alpha < 0) {
                throw new IllegalArgumentException("No value may be lower than 0");
            }
            this.alpha = (float)alpha / 255.0f;
        }

        public FloatRGBA(float red, float green, float blue, float alpha) {
            super(red, green, blue);
            if (alpha > 1.0f) {
                throw new IllegalArgumentException("No value may be higher than 1.0");
            }
            if (alpha < 0.0f) {
                throw new IllegalArgumentException("No value may be lower than 0.0");
            }
            this.alpha = alpha;
        }

        public FloatRGBA(int red, int green, int blue) {
            this(red, green, blue, 255);
        }

        public FloatRGBA(float red, float green, float blue) {
            this(red, green, blue, 1.0f);
        }

        public void setAlpha(float alpha) {
            Color.checkFloatValue(alpha);
            this.alpha = alpha;
        }

        public float alpha() {
            return this.alpha;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = super.serializeNBT();
            tag.method_10548(Color.ALPHA, this.alpha);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            super.deserializeNBT(tag);
            this.alpha = tag.method_10583(Color.ALPHA);
        }
    }

    public static class FloatRGB
    implements ISerializable {
        protected float red;
        protected float green;
        protected float blue;

        public FloatRGB() {
        }

        public FloatRGB(int argb) {
            this.red = (float)class_5253.class_5254.method_27765((int)argb) / 255.0f;
            this.green = (float)class_5253.class_5254.method_27766((int)argb) / 255.0f;
            this.blue = (float)class_5253.class_5254.method_27767((int)argb) / 255.0f;
        }

        protected FloatRGB(int red, int green, int blue) {
            if (red > 255 || green > 255 || blue > 255) {
                throw new IllegalArgumentException("No value may be higher than 255");
            }
            if (red < 0 || green < 0 || blue < 0) {
                throw new IllegalArgumentException("No value may be lower than 0");
            }
            this.red = (float)red / 255.0f;
            this.green = (float)green / 255.0f;
            this.blue = (float)blue / 255.0f;
        }

        public FloatRGB(float red, float green, float blue) {
            if (red > 1.0f || green > 1.0f || blue > 1.0f) {
                throw new IllegalArgumentException("No value may be higher than 1.0");
            }
            if (red < 0.0f || green < 0.0f || blue < 0.0f) {
                throw new IllegalArgumentException("No value may be lower than 0.0");
            }
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public void setRed(float red) {
            Color.checkFloatValue(red);
            this.red = red;
        }

        public float red() {
            return this.red;
        }

        public void setGreen(float green) {
            Color.checkFloatValue(green);
            this.green = green;
        }

        public float green() {
            return this.green;
        }

        public void setBlue(float blue) {
            Color.checkFloatValue(blue);
            this.blue = blue;
        }

        public float blue() {
            return this.blue;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10548(Color.RED, this.red);
            tag.method_10548(Color.GREEN, this.green);
            tag.method_10548(Color.BLUE, this.blue);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            this.red = tag.method_10583(Color.RED);
            this.green = tag.method_10583(Color.GREEN);
            this.blue = tag.method_10583(Color.BLUE);
        }
    }

    public static class IntRGBA
    extends IntRGB {
        public static final Codec<IntRGBA> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf(Color.RED).forGetter(IntRGB::red), (App)Codec.intRange((int)0, (int)255).fieldOf(Color.GREEN).forGetter(IntRGB::green), (App)Codec.intRange((int)0, (int)255).fieldOf(Color.BLUE).forGetter(IntRGB::blue), (App)Codec.intRange((int)0, (int)255).optionalFieldOf(Color.ALPHA, (Object)255).forGetter(IntRGBA::alpha)).apply((Applicative)instance, IntRGBA::new));
        protected int alpha;

        public IntRGBA() {
        }

        public IntRGBA(int argb) {
            super(argb);
            this.alpha = class_5253.class_5254.method_27762((int)argb);
        }

        public IntRGBA(int red, int green, int blue, int alpha) {
            super(red, green, blue);
            if (alpha > 255) {
                throw new IllegalArgumentException("No value may be higher than 255");
            }
            if (alpha < 0) {
                throw new IllegalArgumentException("No value may be lower than 0");
            }
            this.alpha = alpha;
        }

        public IntRGBA(int red, int green, int blue) {
            this(red, green, blue, 255);
        }

        public void setAlpha(int alpha) {
            Color.checkIntValue(alpha);
            this.alpha = alpha;
        }

        public int alpha() {
            return this.alpha;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = super.serializeNBT();
            tag.method_10569(Color.ALPHA, this.alpha);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            super.deserializeNBT(tag);
            this.alpha = tag.method_10550(Color.ALPHA);
        }
    }

    public static class IntRGB
    implements ISerializable {
        protected int red;
        protected int green;
        protected int blue;
        public static final Codec<IntRGB> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf(Color.RED).forGetter(IntRGB::red), (App)Codec.intRange((int)0, (int)255).fieldOf(Color.GREEN).forGetter(IntRGB::green), (App)Codec.intRange((int)0, (int)255).fieldOf(Color.BLUE).forGetter(IntRGB::blue)).apply((Applicative)instance, IntRGB::new));

        public IntRGB() {
        }

        public IntRGB(int argb) {
            this.red = class_5253.class_5254.method_27765((int)argb);
            this.green = class_5253.class_5254.method_27766((int)argb);
            this.blue = class_5253.class_5254.method_27767((int)argb);
        }

        public IntRGB(int red, int green, int blue) {
            if (red > 255 || green > 255 || blue > 255) {
                throw new IllegalArgumentException("No value may be higher than 255");
            }
            if (red < 0 || green < 0 || blue < 0) {
                throw new IllegalArgumentException("No value may be lower than 0");
            }
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public void setRed(int red) {
            Color.checkIntValue(red);
            this.red = red;
        }

        public int red() {
            return this.red;
        }

        public void setGreen(int green) {
            Color.checkIntValue(green);
            this.green = green;
        }

        public int green() {
            return this.green;
        }

        public void setBlue(int blue) {
            Color.checkIntValue(blue);
            this.blue = blue;
        }

        public int blue() {
            return this.blue;
        }

        @Override
        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10569(Color.RED, this.red);
            tag.method_10569(Color.GREEN, this.green);
            tag.method_10569(Color.BLUE, this.blue);
            return tag;
        }

        @Override
        public void deserializeNBT(class_2487 tag) {
            this.red = tag.method_10550(Color.RED);
            this.green = tag.method_10550(Color.GREEN);
            this.blue = tag.method_10550(Color.BLUE);
        }
    }
}

