/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render;

import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.config.GeneralConfig;

public class LightEffects {
    private static float starBrightness = 0.0f;
    private static float dustCloudBrightness = 0.0f;

    public static float lightSourceStarDimming(ClientLevel level, Camera camera) {
        int brightnessAtBlock = level.m_5518_().m_75831_(camera.m_90592_().m_20097_().m_7494_(), 15);
        float brightness = 0.5f + 1.5f * ((15.0f - (float)brightnessAtBlock) / 15.0f);
        if (starBrightness < brightness) {
            if ((starBrightness += 0.01f) > brightness) {
                starBrightness = brightness;
            }
        } else if (starBrightness > brightness && (starBrightness -= 0.01f) < brightness) {
            starBrightness = brightness;
        }
        return starBrightness;
    }

    public static float lightSourceDustCloudDimming(ClientLevel level, Camera camera) {
        int brightnessAtBlock = level.m_5518_().m_75831_(camera.m_90592_().m_20097_().m_7494_(), 15);
        float brightness = 2.0f * ((7.0f - (float)brightnessAtBlock) / 7.0f);
        if (brightness < 0.0f) {
            brightness = 0.0f;
        }
        if (dustCloudBrightness < brightness) {
            if ((dustCloudBrightness += 0.001f) > brightness) {
                dustCloudBrightness = brightness;
            }
        } else if (dustCloudBrightness > brightness && (dustCloudBrightness -= 0.001f) < brightness) {
            dustCloudBrightness = brightness;
        }
        return dustCloudBrightness;
    }

    public static float rainDimming(ClientLevel level, float partialTicks) {
        return 1.0f - level.m_46722_(partialTicks);
    }

    public static float getStarBrightness(ViewCenter viewCenter, ClientLevel level, Camera camera, float partialTicks) {
        float brightness = (float)GeneralConfig.star_brightness.get() / 100.0f;
        brightness = !viewCenter.stars().duringDay() ? (brightness *= level.m_104811_(partialTicks)) : (brightness *= 0.5f);
        brightness = GeneralConfig.light_pollution.get() ? (brightness *= LightEffects.lightSourceStarDimming(level, camera)) : (brightness *= 2.0f);
        return brightness;
    }

    public static float getDustBrightness(ViewCenter viewCenter, ClientLevel level, Camera camera, float partialTicks) {
        float brightness = (float)GeneralConfig.dust_cloud_brightness.get() / 100.0f;
        brightness = !viewCenter.stars().duringDay() ? (brightness *= level.m_104811_(partialTicks)) : (brightness *= 0.5f);
        brightness = GeneralConfig.light_pollution.get() ? (brightness *= LightEffects.lightSourceDustCloudDimming(level, camera)) : (brightness *= 2.0f);
        return brightness;
    }

    public static float dayBrightness(ViewCenter viewCenter, float size, long ticks, ClientLevel level, Camera camera, float partialTicks) {
        float aboveSize;
        float brightnessPercentage;
        float minBrightness;
        float brightness = LightEffects.getStarBrightness(viewCenter, level, camera, partialTicks);
        if (brightness < viewCenter.dayBlending().dayMaxBrightness() && size > viewCenter.dayBlending().dayMinVisibleSize() && brightness < (minBrightness = (brightnessPercentage = (aboveSize = size >= viewCenter.dayBlending().dayMaxVisibleSize() ? viewCenter.dayBlending().dayVisibleRange() : size - viewCenter.dayBlending().dayMinVisibleSize()) / viewCenter.dayBlending().dayVisibleRange()) * viewCenter.dayBlending().dayMaxBrightness())) {
            brightness = minBrightness;
        }
        return viewCenter.stars().ignoreRain() ? brightness : brightness * LightEffects.rainDimming(level, partialTicks);
    }

    public static float starDayBrightness(ViewCenter viewCenter, float size, long ticks, ClientLevel level, Camera camera, float partialTicks) {
        float aboveSize;
        float brightnessPercentage;
        float minBrightness;
        float brightness = LightEffects.getStarBrightness(viewCenter, level, camera, partialTicks);
        if (brightness < viewCenter.sunDayBlending().dayMaxBrightness() && size > viewCenter.sunDayBlending().dayMinVisibleSize() && brightness < (minBrightness = (brightnessPercentage = (aboveSize = size >= viewCenter.sunDayBlending().dayMaxVisibleSize() ? viewCenter.sunDayBlending().dayVisibleRange() : size - viewCenter.sunDayBlending().dayMinVisibleSize()) / viewCenter.sunDayBlending().dayVisibleRange()) * viewCenter.sunDayBlending().dayMaxBrightness())) {
            brightness = minBrightness;
        }
        return viewCenter.stars().ignoreRain() ? brightness : brightness * LightEffects.rainDimming(level, partialTicks);
    }

    public static float dustCloudBrightness(ViewCenter viewCenter, ClientLevel level, Camera camera, float partialTicks) {
        float brightness = LightEffects.getDustBrightness(viewCenter, level, camera, partialTicks);
        return viewCenter.stars().ignoreRain() ? brightness : brightness * LightEffects.rainDimming(level, partialTicks);
    }

    public static float nebulaBrightness(ViewCenter viewCenter, float size, long ticks, ClientLevel level, Camera camera, float partialTicks) {
        float aboveSize;
        float brightnessPercentage;
        float minBrightness;
        float brightness = LightEffects.getDustBrightness(viewCenter, level, camera, partialTicks);
        if (brightness < viewCenter.dayBlending().dayMaxBrightness() && size > viewCenter.dayBlending().dayMinVisibleSize() && brightness < (minBrightness = (brightnessPercentage = (aboveSize = size >= viewCenter.dayBlending().dayMaxVisibleSize() ? viewCenter.dayBlending().dayVisibleRange() : size - viewCenter.dayBlending().dayMinVisibleSize()) / viewCenter.dayBlending().dayVisibleRange()) * viewCenter.dayBlending().dayMaxBrightness())) {
            brightness = minBrightness;
        }
        return viewCenter.stars().ignoreRain() ? brightness : brightness * LightEffects.rainDimming(level, partialTicks);
    }

    public static float starBrightness(ViewCenter viewCenter, ClientLevel level, Camera camera, float partialTicks) {
        float brightness = LightEffects.getStarBrightness(viewCenter, level, camera, partialTicks);
        return viewCenter.stars().ignoreRain() ? brightness : brightness * LightEffects.rainDimming(level, partialTicks);
    }
}

