/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import org.joml.Math;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class AxisRotation
implements INBTSerializable<CompoundTag> {
    public static final String X_AXIS = "x_axis";
    public static final String Y_AXIS = "y_axis";
    public static final String Z_AXIS = "z_axis";
    private boolean inDegrees;
    private double xAxis;
    private double yAxis;
    private double zAxis;
    private Quaterniond quaterniond;
    private Quaternionf quaternionf;
    public static final Codec<AxisRotation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("in_degrees", (Object)true).forGetter(axisRotation -> axisRotation.inDegrees), (App)Codec.DOUBLE.fieldOf(X_AXIS).forGetter(AxisRotation::xAxis), (App)Codec.DOUBLE.fieldOf(Y_AXIS).forGetter(AxisRotation::yAxis), (App)Codec.DOUBLE.fieldOf(Z_AXIS).forGetter(AxisRotation::zAxis)).apply((Applicative)instance, AxisRotation::new));

    public AxisRotation(boolean inDegrees, double xAxis, double yAxis, double zAxis) {
        this.inDegrees = inDegrees;
        if (inDegrees) {
            this.xAxis = Math.toRadians((double)xAxis);
            this.yAxis = Math.toRadians((double)yAxis);
            this.zAxis = Math.toRadians((double)zAxis);
        } else {
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.zAxis = zAxis;
        }
        this.setupQuaternions();
    }

    private void setupQuaternions() {
        Quaterniond quaterniondX = this.rotationdX(this.xAxis);
        Quaterniond quaterniondY = new Quaterniond().rotationY(this.yAxis);
        Quaterniond quaterniondZ = new Quaterniond().rotationZ(this.zAxis);
        this.quaterniond = quaterniondX.mul((Quaterniondc)quaterniondZ.mul((Quaterniondc)quaterniondY));
        Quaternionf quaternionfX = new Quaternionf().rotationX((float)this.xAxis);
        Quaternionf quaternionfY = new Quaternionf().rotationY((float)this.yAxis);
        Quaternionf quaternionfZ = new Quaternionf().rotationZ((float)this.zAxis);
        Quaternionf quatf = quaternionfZ.mul((Quaternionfc)quaternionfY);
        this.quaternionf = quaternionfX.mul((Quaternionfc)quatf);
    }

    private Quaterniond rotationdX(double angle) {
        Quaterniond quaternion = new Quaterniond();
        double sin = Math.sin((double)(angle * 0.5));
        double cos = Math.cosFromSin((double)sin, (double)(angle * 0.5));
        return quaternion.set(sin, 0.0, 0.0, cos);
    }

    public AxisRotation(double xAxis, double yAxis, double zAxis) {
        this(true, xAxis, yAxis, zAxis);
    }

    public AxisRotation() {
        this(false, 0.0, 0.0, 0.0);
    }

    public double xAxis() {
        return this.xAxis;
    }

    public double yAxis() {
        return this.yAxis;
    }

    public double zAxis() {
        return this.zAxis;
    }

    public Quaternionf quaternionf() {
        return this.quaternionf;
    }

    public Quaterniond quaterniond() {
        return this.quaterniond;
    }

    public AxisRotation add(AxisRotation other) {
        return new AxisRotation(false, this.xAxis + other.xAxis, this.yAxis + other.yAxis, this.zAxis + other.zAxis);
    }

    public AxisRotation add(double xRot, double yRot, double zRot) {
        return new AxisRotation(false, this.xAxis + xRot, this.yAxis + yRot, this.zAxis + zRot);
    }

    public AxisRotation sub(AxisRotation other) {
        return new AxisRotation(false, this.xAxis - other.xAxis, this.yAxis - other.yAxis, this.zAxis - other.zAxis);
    }

    public AxisRotation copy() {
        return new AxisRotation(false, this.xAxis, this.yAxis, this.zAxis);
    }

    public String toString() {
        return "( xAxis: " + Math.toDegrees((double)this.xAxis) + "\u00b0, yAxis: " + Math.toDegrees((double)this.yAxis) + "\u00b0, zAxis: " + Math.toDegrees((double)this.zAxis) + "\u00b0 )";
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_(X_AXIS, this.xAxis);
        tag.m_128347_(Y_AXIS, this.yAxis);
        tag.m_128347_(Z_AXIS, this.zAxis);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.inDegrees = false;
        this.xAxis = tag.m_128459_(X_AXIS);
        this.yAxis = tag.m_128459_(Y_AXIS);
        this.zAxis = tag.m_128459_(Z_AXIS);
        this.setupQuaternions();
    }
}

