/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.common.util.SpaceCoords;

public class SpaceRegion
implements INBTSerializable<CompoundTag> {
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    public static final long LY_PER_REGION = 2000000L;
    public static final long LY_PER_REGION_HALF = 1000000L;
    private RegionPos pos;
    protected ArrayList<SpaceObject> children;

    public SpaceRegion(RegionPos pos) {
        this.pos = pos;
        this.children = new ArrayList();
    }

    public SpaceRegion(long x, long y, long z) {
        this(new RegionPos(x, y, z));
    }

    public SpaceRegion() {
        this(0L, 0L, 0L);
    }

    public RegionPos getRegionPos() {
        return this.pos;
    }

    public ArrayList<SpaceObject> getChildren() {
        return this.children;
    }

    public boolean addChild(SpaceObject child) {
        if (this.children.contains(child)) {
            return false;
        }
        this.children.add(child);
        return true;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putLong(X, this.pos.x());
        tag.putLong(Y, this.pos.y());
        tag.putLong(Z, this.pos.z());
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.pos = new RegionPos(tag.getLong(X), tag.getLong(Y), tag.getLong(Z));
    }

    public static class RegionPos {
        private long x;
        private long y;
        private long z;

        public RegionPos(long x, long y, long z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public RegionPos(SpaceCoords coords) {
            this((coords.x().ly() - 1000000L) / 2000000L, (coords.y().ly() - 1000000L) / 2000000L, (coords.z().ly() - 1000000L) / 2000000L);
        }

        public long x() {
            return this.x;
        }

        public long y() {
            return this.y;
        }

        public long z() {
            return this.z;
        }

        public long lyX() {
            return this.x * 2000000L;
        }

        public long lyY() {
            return this.y * 2000000L;
        }

        public long lyZ() {
            return this.z * 2000000L;
        }

        public boolean isInRange(RegionPos other, int range) {
            return Math.abs(this.x - other.x) < (long)range && Math.abs(this.y - other.y) < (long)range && Math.abs(this.z - other.z) < (long)range;
        }

        public final boolean equals(Object object) {
            if (object instanceof RegionPos) {
                RegionPos pos = (RegionPos)object;
                return this.x == pos.x && this.y == pos.y && this.z == pos.z;
            }
            return false;
        }

        public final int hashCode() {
            int result = (int)this.x;
            result = 31 * result + (int)this.y;
            result = 31 * result + (int)this.z;
            return result;
        }

        public String toString() {
            return "{x: " + this.x + ", y: " + this.y + ", z: " + this.z + "}";
        }
    }
}

