/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.stellarview.StellarView;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;

public abstract class SpaceObject
implements INBTSerializable<CompoundTag> {
    public static final String PARENT = "parent";
    public static final String COORDS = "coords";
    public static final String AXIS_ROTATION = "axis_rotation";
    public static final String ID = "id";
    public static final ResourceLocation SPACE_OBJECT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"space_object");
    public static final ResourceKey<Registry<SpaceObject>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)SPACE_OBJECT_LOCATION);
    public static final Codec<ResourceKey<SpaceObject>> RESOURCE_KEY_CODEC = ResourceKey.codec(REGISTRY_KEY);
    @Nullable
    protected ParentInfo parentInfo;
    @Nullable
    protected SpaceObject parent;
    protected ArrayList<SpaceObject> children = new ArrayList();
    protected SpaceCoords coords;
    protected AxisRotation axisRotation;
    protected ResourceLocation location;

    public SpaceObject() {
    }

    public SpaceObject(Optional<ParentInfo> parentInfo, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation) {
        this.parentInfo = parentInfo.orElse(null);
        this.coords = coords.left().isPresent() ? (SpaceCoords)coords.left().get() : ((StellarCoordinates.Equatorial)coords.right().get()).toGalactic().toSpaceCoords();
        this.axisRotation = axisRotation;
    }

    public SpaceCoords getCoords() {
        return this.coords;
    }

    public AxisRotation getAxisRotation() {
        return this.axisRotation;
    }

    public ArrayList<SpaceObject> getChildren() {
        return this.children;
    }

    public Optional<ParentInfo> getParentInfo() {
        return Optional.ofNullable(this.parentInfo);
    }

    @Nullable
    public ResourceLocation getParentLocation() {
        if (this.parentInfo != null) {
            return this.parentInfo.parentLocation();
        }
        return null;
    }

    public boolean isRelative() {
        if (this.parentInfo != null) {
            return this.parentInfo.relative();
        }
        return true;
    }

    public Optional<SpaceObject> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public void setResourceLocation(ResourceLocation resourceLocation) {
        this.location = resourceLocation;
    }

    public static double distanceSize(double distance) {
        return 1.0 / distance;
    }

    public void setPosAndRotation(SpaceCoords coords, AxisRotation axisRotation) {
        this.removeCoordsAndRotationFromChildren(this.getCoords(), this.getAxisRotation());
        if (this.parent != null && this.isRelative()) {
            this.coords = coords.add(this.parent.getCoords());
            this.axisRotation = axisRotation.add(this.parent.getAxisRotation());
        } else {
            this.coords = coords;
            this.axisRotation = axisRotation;
        }
        this.addCoordsAndRotationToChildren(this.coords, this.axisRotation);
    }

    public void addParent(SpaceObject parent) {
        this.parent = parent;
    }

    public boolean addChildRaw(SpaceObject child) {
        if (child.parent != null) {
            StellarView.LOGGER.error(this.toString() + " already has a parent");
            return false;
        }
        this.children.add(child);
        child.addParent(this);
        return true;
    }

    public void addChild(SpaceObject child) {
        if (!this.addChildRaw(child)) {
            return;
        }
        if (child.isRelative()) {
            child.coords = child.coords.add(this.coords);
            child.axisRotation = child.axisRotation.add(this.axisRotation);
            child.addCoordsAndRotationToChildren(this.coords, this.axisRotation);
        }
    }

    protected void addCoordsAndRotationToChildren(SpaceCoords coords, AxisRotation axisRotation) {
        for (SpaceObject childOfChild : this.children) {
            if (!childOfChild.isRelative()) continue;
            childOfChild.coords = childOfChild.coords.add(coords);
            childOfChild.axisRotation = childOfChild.axisRotation.add(axisRotation);
            childOfChild.addCoordsAndRotationToChildren(coords, axisRotation);
        }
    }

    protected void removeCoordsAndRotationFromChildren(SpaceCoords coords, AxisRotation axisRotation) {
        for (SpaceObject childOfChild : this.children) {
            if (!childOfChild.isRelative()) continue;
            childOfChild.coords = childOfChild.coords.sub(coords);
            childOfChild.axisRotation = childOfChild.axisRotation.sub(axisRotation);
            childOfChild.removeCoordsAndRotationFromChildren(coords, axisRotation);
        }
    }

    public String toString() {
        if (this.location != null) {
            return this.location.toString();
        }
        return this.getClass().toString();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (this.location != null) {
            tag.putString(ID, this.location.toString());
        }
        if (this.parentInfo != null) {
            tag.put(PARENT, (Tag)this.parentInfo.serializeNBT(provider));
        }
        tag.put(COORDS, (Tag)this.coords.serializeNBT(provider));
        tag.put(AXIS_ROTATION, (Tag)this.axisRotation.serializeNBT(provider));
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        if (tag.contains(ID)) {
            this.location = ResourceLocation.parse((String)tag.getString(ID));
        }
        if (tag.contains(PARENT)) {
            this.parentInfo = new ParentInfo();
            this.parentInfo.deserializeNBT(provider, tag.getCompound(PARENT));
        }
        this.coords = new SpaceCoords();
        this.coords.deserializeNBT(provider, tag.getCompound(COORDS));
        this.axisRotation = new AxisRotation();
        this.axisRotation.deserializeNBT(provider, tag.getCompound(AXIS_ROTATION));
    }

    public static class ParentInfo
    implements INBTSerializable<CompoundTag> {
        public static final String PARENT_LOCATION = "location";
        public static final String RELATIVE = "relative";
        public static final Codec<ParentInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf(PARENT_LOCATION).forGetter(ParentInfo::parentLocation), (App)Codec.BOOL.optionalFieldOf(RELATIVE, (Object)true).forGetter(ParentInfo::relative)).apply((Applicative)instance, ParentInfo::new));
        protected ResourceLocation parentLocation;
        protected boolean relative;

        public ParentInfo() {
        }

        public ParentInfo(ResourceLocation parentLocation, boolean relative) {
            this.parentLocation = parentLocation;
            this.relative = relative;
        }

        public ResourceLocation parentLocation() {
            return this.parentLocation;
        }

        public boolean relative() {
            return this.relative;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putString(PARENT_LOCATION, this.parentLocation.toString());
            tag.putBoolean(RELATIVE, this.relative);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            this.parentLocation = ResourceLocation.parse((String)tag.getString(PARENT_LOCATION));
            this.relative = tag.getBoolean(RELATIVE);
        }
    }
}

