/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.api.common.space_objects.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.common.util.AxisRotation;
import net.povstalec.stellarview.common.util.SpaceCoords;
import net.povstalec.stellarview.common.util.StellarCoordinates;

public class StarField
extends SpaceObject {
    public static final long LOD_DISTANCE_HIGH = 10000000L;
    public static final long LOD_DISTANCE_MEDIUM = 5000000L;
    public static final long LOD_DISTANCE_LOW = 0L;
    public static final ResourceLocation DEFAULT_STAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"textures/environment/star.png");
    public static final ResourceLocation DEFAULT_DUST_CLOUD_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellarview", (String)"textures/environment/dust_cloud.png");
    public static final String DUST_CLOUDS = "dust_clouds";
    public static final String DUST_CLOUD_INFO = "dust_cloud_info";
    public static final String DUST_CLOUD_TEXTURE = "dust_cloud_texture";
    public static final String CLUMP_DUST_CLOUDS_IN_CENTER = "clump_dust_clouds_in_center";
    public static final String DUST_CLOUD_STRETCH = "dust_cloud_stretch";
    public static final String STARS = "stars";
    public static final String STAR_INFO = "star_info";
    public static final String STAR_TEXTURE = "star_texture";
    public static final String CLUMP_STARS_IN_CENTER = "clump_stars_in_center";
    public static final String STAR_STRETCH = "star_stretch";
    public static final String SEED = "seed";
    public static final String DIAMETER_LY = "diameter_ly";
    public static final String SPIRAL_ARMS = "spiral_arms";
    protected int dustClouds;
    protected ResourceLocation dustCloudInfo;
    protected ResourceLocation dustCloudTexture;
    protected boolean clumpDustCloudsInCenter;
    protected Stretch dustCloudStretch;
    protected int stars;
    protected ResourceLocation starInfo;
    protected ResourceLocation starTexture;
    protected boolean clumpStarsInCenter;
    protected Stretch starStretch;
    protected long seed;
    protected int diameter;
    protected ArrayList<SpiralArm> spiralArms;
    public static final Codec<StarField> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpaceObject.ParentInfo.CODEC.optionalFieldOf("parent").forGetter(SpaceObject::getParentInfo), (App)Codec.either(SpaceCoords.CODEC, StellarCoordinates.Equatorial.CODEC).fieldOf("coords").forGetter(object -> Either.left((Object)object.getCoords())), (App)AxisRotation.CODEC.fieldOf("axis_rotation").forGetter(SpaceObject::getAxisRotation), (App)Codec.intRange((int)0, (int)4000).optionalFieldOf(DUST_CLOUDS, (Object)0).forGetter(StarField::getDustClouds), (App)ResourceLocation.CODEC.optionalFieldOf(DUST_CLOUD_INFO).forGetter(starField -> Optional.ofNullable(starField.dustCloudInfo)), (App)ResourceLocation.CODEC.optionalFieldOf(DUST_CLOUD_TEXTURE, (Object)DEFAULT_DUST_CLOUD_TEXTURE).forGetter(StarField::getDustCloudTexture), (App)Codec.BOOL.optionalFieldOf(CLUMP_DUST_CLOUDS_IN_CENTER, (Object)true).forGetter(StarField::clumpDustCloudsInCenter), (App)Stretch.CODEC.optionalFieldOf(DUST_CLOUD_STRETCH, (Object)Stretch.DEFAULT_STRETCH).forGetter(StarField::dustCloudStretch), (App)Codec.intRange((int)0, (int)30000).fieldOf(STARS).forGetter(StarField::getStars), (App)ResourceLocation.CODEC.optionalFieldOf(STAR_INFO).forGetter(starField -> Optional.ofNullable(starField.starInfo)), (App)ResourceLocation.CODEC.optionalFieldOf(STAR_TEXTURE, (Object)DEFAULT_STAR_TEXTURE).forGetter(starField -> starField.starTexture), (App)Codec.BOOL.optionalFieldOf(CLUMP_STARS_IN_CENTER, (Object)true).forGetter(StarField::clumpStarsInCenter), (App)Stretch.CODEC.optionalFieldOf(STAR_STRETCH, (Object)Stretch.DEFAULT_STRETCH).forGetter(StarField::starStretch), (App)Codec.LONG.fieldOf(SEED).forGetter(StarField::getSeed), (App)Codec.INT.fieldOf(DIAMETER_LY).forGetter(StarField::getDiameter), (App)SpiralArm.CODEC.listOf().optionalFieldOf(SPIRAL_ARMS, new ArrayList()).forGetter(starField -> starField.spiralArms)).apply((Applicative)instance, StarField::new));

    public StarField() {
    }

    public StarField(Optional<SpaceObject.ParentInfo> parent, Either<SpaceCoords, StellarCoordinates.Equatorial> coords, AxisRotation axisRotation, int dustClouds, Optional<ResourceLocation> dustCloudInfo, ResourceLocation dustCloudTexture, boolean clumpDustCloudsInCenter, Stretch dustCloudStretch, int stars, Optional<ResourceLocation> starInfo, ResourceLocation starTexture, boolean clumpStarsInCenter, Stretch starStretch, long seed, int diameter, List<SpiralArm> spiralArms) {
        super(parent, coords, axisRotation);
        this.dustClouds = dustClouds;
        this.dustCloudInfo = dustCloudInfo.isPresent() ? dustCloudInfo.get() : null;
        this.dustCloudTexture = dustCloudTexture;
        this.clumpDustCloudsInCenter = clumpDustCloudsInCenter;
        this.dustCloudStretch = dustCloudStretch;
        this.stars = stars;
        this.starInfo = starInfo.isPresent() ? starInfo.get() : null;
        this.starTexture = starTexture;
        this.clumpStarsInCenter = clumpStarsInCenter;
        this.starStretch = starStretch;
        this.seed = seed;
        this.diameter = diameter;
        this.spiralArms = new ArrayList<SpiralArm>(spiralArms);
    }

    public int getDustClouds() {
        return this.dustClouds;
    }

    @Nullable
    public ResourceLocation getDustCloudInfo() {
        return this.dustCloudInfo;
    }

    public ResourceLocation getDustCloudTexture() {
        return this.dustCloudTexture;
    }

    @Nullable
    public ResourceLocation getStarInfo() {
        return this.starInfo;
    }

    public boolean clumpDustCloudsInCenter() {
        return this.clumpDustCloudsInCenter;
    }

    public Stretch dustCloudStretch() {
        return this.dustCloudStretch;
    }

    public ResourceLocation getStarTexture() {
        return this.starTexture;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public int getStars() {
        return this.stars;
    }

    public boolean clumpStarsInCenter() {
        return this.clumpStarsInCenter;
    }

    public Stretch starStretch() {
        return this.starStretch;
    }

    public List<SpiralArm> getSpiralArms() {
        return this.spiralArms;
    }

    public SpiralArm getSpiralArm(int armIndex) {
        if (armIndex < 0 || armIndex >= this.spiralArms.size()) {
            return null;
        }
        return this.spiralArms.get(armIndex);
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.putInt(DUST_CLOUDS, this.dustClouds);
        tag.putString(DUST_CLOUD_TEXTURE, this.dustCloudTexture.toString());
        if (this.dustCloudInfo != null) {
            tag.putString(DUST_CLOUD_INFO, this.dustCloudInfo.toString());
        }
        tag.putBoolean(CLUMP_DUST_CLOUDS_IN_CENTER, this.clumpDustCloudsInCenter);
        tag.put(DUST_CLOUD_STRETCH, (Tag)this.dustCloudStretch.serializeNBT(provider));
        tag.putInt(STARS, this.stars);
        tag.putString(STAR_TEXTURE, this.starTexture.toString());
        if (this.starInfo != null) {
            tag.putString(STAR_INFO, this.starInfo.toString());
        }
        tag.putBoolean(CLUMP_STARS_IN_CENTER, this.clumpStarsInCenter);
        tag.put(STAR_STRETCH, (Tag)this.starStretch.serializeNBT(provider));
        tag.putLong(SEED, this.seed);
        tag.putInt(DIAMETER_LY, this.diameter);
        CompoundTag armsTag = new CompoundTag();
        for (int i = 0; i < this.spiralArms.size(); ++i) {
            armsTag.put("spiral_arm_" + i, (Tag)this.spiralArms.get(i).serializeNBT(provider));
        }
        tag.put(SPIRAL_ARMS, (Tag)armsTag);
        return tag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        super.deserializeNBT(provider, tag);
        this.dustClouds = tag.getInt(DUST_CLOUDS);
        this.dustCloudTexture = ResourceLocation.parse((String)tag.getString(DUST_CLOUD_TEXTURE));
        this.dustCloudInfo = tag.contains(DUST_CLOUD_INFO) ? ResourceLocation.parse((String)tag.getString(DUST_CLOUD_INFO)) : null;
        this.clumpDustCloudsInCenter = tag.getBoolean(CLUMP_DUST_CLOUDS_IN_CENTER);
        this.dustCloudStretch = new Stretch();
        this.dustCloudStretch.deserializeNBT(provider, tag.getCompound(DUST_CLOUD_STRETCH));
        this.stars = tag.getInt(STARS);
        this.starTexture = ResourceLocation.parse((String)tag.getString(STAR_TEXTURE));
        this.starInfo = tag.contains(STAR_INFO) ? ResourceLocation.parse((String)tag.getString(STAR_INFO)) : null;
        this.clumpStarsInCenter = tag.getBoolean(CLUMP_STARS_IN_CENTER);
        this.starStretch = new Stretch();
        this.starStretch.deserializeNBT(provider, tag.getCompound(STAR_STRETCH));
        this.seed = tag.getLong(SEED);
        this.diameter = tag.getInt(DIAMETER_LY);
        this.spiralArms = new ArrayList();
        CompoundTag armsTag = tag.getCompound(SPIRAL_ARMS);
        for (String key : armsTag.getAllKeys()) {
            SpiralArm arm = new SpiralArm();
            arm.deserializeNBT(provider, armsTag.getCompound(key));
            this.spiralArms.add(arm);
        }
    }

    public static class Stretch
    implements INBTSerializable<CompoundTag> {
        public static final String X_STRETCH = "x";
        public static final String Y_STRETCH = "y";
        public static final String Z_STRETCH = "z";
        protected double xStretch;
        protected double yStretch;
        protected double zStretch;
        public static final Stretch DEFAULT_STRETCH = new Stretch();
        public static final Codec<Stretch> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf(X_STRETCH, (Object)1.0).forGetter(stretch -> stretch.xStretch), (App)Codec.DOUBLE.optionalFieldOf(Y_STRETCH, (Object)1.0).forGetter(stretch -> stretch.yStretch), (App)Codec.DOUBLE.optionalFieldOf(Z_STRETCH, (Object)1.0).forGetter(stretch -> stretch.zStretch)).apply((Applicative)instance, Stretch::new));

        public Stretch(double xStretch, double yStretch, double zStretch) {
            this.xStretch = xStretch;
            this.yStretch = yStretch;
            this.zStretch = zStretch;
        }

        public Stretch() {
            this(1.0, 1.0, 1.0);
        }

        public double xStretch() {
            return this.xStretch;
        }

        public double yStretch() {
            return this.yStretch;
        }

        public double zStretch() {
            return this.zStretch;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putDouble(X_STRETCH, this.xStretch);
            tag.putDouble(Y_STRETCH, this.yStretch);
            tag.putDouble(Z_STRETCH, this.zStretch);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            this.xStretch = tag.getDouble(X_STRETCH);
            this.yStretch = tag.getDouble(Y_STRETCH);
            this.zStretch = tag.getDouble(Z_STRETCH);
        }
    }

    public static class SpiralArm
    implements INBTSerializable<CompoundTag> {
        public static final String STARS = "stars";
        public static final String ARM_ROTATION = "arm_rotation";
        public static final String ARM_LENGTH = "arm_length";
        public static final String ARM_THICKNESS = "arm_thickness";
        public static final String CLUMP_STARS_IN_CENTER = "clump_stars_in_center";
        @Nullable
        protected ResourceLocation dustCloudInfo;
        protected int armDustClouds;
        protected int armStars;
        protected double armRotation;
        protected double armLength;
        protected double armThickness;
        protected boolean clumpStarsInCenter;
        protected boolean clumpDustCloudsInCenter;
        public static final Codec<SpiralArm> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf(StarField.DUST_CLOUDS, (Object)0).forGetter(SpiralArm::armDustClouds), (App)ResourceLocation.CODEC.optionalFieldOf(StarField.DUST_CLOUD_INFO).forGetter(arm -> Optional.ofNullable(arm.dustCloudInfo)), (App)Codec.INT.fieldOf("stars").forGetter(SpiralArm::armStars), (App)Codec.DOUBLE.fieldOf(ARM_ROTATION).forGetter(SpiralArm::armRotation), (App)Codec.DOUBLE.fieldOf(ARM_LENGTH).forGetter(SpiralArm::armLength), (App)Codec.DOUBLE.fieldOf(ARM_THICKNESS).forGetter(SpiralArm::armThickness), (App)Codec.BOOL.optionalFieldOf("clump_stars_in_center", (Object)true).forGetter(SpiralArm::clumpStarsInCenter)).apply((Applicative)instance, SpiralArm::new));

        public SpiralArm() {
        }

        public SpiralArm(int armDustClouds, Optional<ResourceLocation> dustCloudInfo, int armStars, double armRotationDegrees, double armLength, double armThickness, boolean clumpStarsInCenter) {
            this.armDustClouds = armDustClouds;
            this.dustCloudInfo = dustCloudInfo.isPresent() ? dustCloudInfo.get() : null;
            this.armStars = armStars;
            this.armRotation = Math.toRadians(armRotationDegrees);
            this.armLength = armLength;
            this.armThickness = armThickness;
            this.clumpStarsInCenter = clumpStarsInCenter;
        }

        public int armDustClouds() {
            return this.armDustClouds;
        }

        @Nullable
        public ResourceLocation dustCloudInfo() {
            return this.dustCloudInfo;
        }

        public int armStars() {
            return this.armStars;
        }

        public double armRotation() {
            return this.armRotation;
        }

        public double armLength() {
            return this.armLength;
        }

        public double armThickness() {
            return this.armThickness;
        }

        public boolean clumpStarsInCenter() {
            return this.clumpStarsInCenter;
        }

        public boolean clumpDustCloudsInCenter() {
            return this.clumpDustCloudsInCenter;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.putInt(StarField.DUST_CLOUDS, this.armDustClouds);
            if (this.dustCloudInfo != null) {
                tag.putString(StarField.DUST_CLOUD_INFO, this.dustCloudInfo.toString());
            }
            tag.putInt("stars", this.armStars);
            tag.putDouble(ARM_ROTATION, this.armRotation);
            tag.putDouble(ARM_LENGTH, this.armLength);
            tag.putDouble(ARM_THICKNESS, this.armThickness);
            tag.putBoolean("clump_stars_in_center", this.clumpStarsInCenter);
            tag.putBoolean(StarField.CLUMP_DUST_CLOUDS_IN_CENTER, this.clumpDustCloudsInCenter);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
            this.armDustClouds = tag.getInt(StarField.DUST_CLOUDS);
            this.dustCloudInfo = tag.contains(StarField.DUST_CLOUD_INFO) ? ResourceLocation.parse((String)tag.getString(StarField.DUST_CLOUD_INFO)) : null;
            this.armStars = tag.getInt("stars");
            this.armRotation = tag.getDouble(ARM_ROTATION);
            this.armLength = tag.getDouble(ARM_LENGTH);
            this.armThickness = tag.getDouble(ARM_THICKNESS);
            this.clumpStarsInCenter = tag.getBoolean("clump_stars_in_center");
            this.clumpDustCloudsInCenter = tag.getBoolean(StarField.CLUMP_DUST_CLOUDS_IN_CENTER);
        }
    }

    public static enum LevelOfDetail {
        LOD1(225, 10000000L),
        LOD2(190, 5000000L),
        LOD3(0, 0L);

        short minBrightness;
        long minDistanceSquared;

        private LevelOfDetail(short minBrightness, long minDistance) {
            this.minBrightness = minBrightness;
            this.minDistanceSquared = minDistance * minDistance;
        }

        public static LevelOfDetail fromBrightness(short brightness) {
            if (brightness < LevelOfDetail.LOD2.minBrightness) {
                return LOD3;
            }
            if (brightness < LevelOfDetail.LOD1.minBrightness) {
                return LOD2;
            }
            return LOD1;
        }

        public static LevelOfDetail fromDistance(long distance) {
            long distanceSquared = distance * distance;
            if (distanceSquared >= LevelOfDetail.LOD1.minDistanceSquared) {
                return LOD1;
            }
            if (distanceSquared >= LevelOfDetail.LOD2.minDistanceSquared) {
                return LOD2;
            }
            return LOD3;
        }

        public static LevelOfDetail fromDistance(SpaceCoords difference) {
            long distanceSquared = difference.lyDistanceSquared();
            if (distanceSquared >= LevelOfDetail.LOD1.minDistanceSquared) {
                return LOD1;
            }
            if (distanceSquared >= LevelOfDetail.LOD2.minDistanceSquared) {
                return LOD2;
            }
            return LOD3;
        }
    }
}

