/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render;

import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.povstalec.stellarview.api.common.SpaceRegion;
import net.povstalec.stellarview.api.common.space_objects.SpaceObject;
import net.povstalec.stellarview.client.render.SpaceRenderer;
import net.povstalec.stellarview.client.render.space_objects.GravityLenseRenderer;
import net.povstalec.stellarview.client.render.space_objects.OrbitingObjectRenderer;
import net.povstalec.stellarview.client.render.space_objects.SpaceObjectRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.ConstellationRenderer;
import net.povstalec.stellarview.client.render.space_objects.resourcepack.StarFieldRenderer;
import net.povstalec.stellarview.client.resourcepack.ViewCenter;
import net.povstalec.stellarview.common.config.GeneralConfig;
import net.povstalec.stellarview.common.util.AxisRotation;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SpaceRegionRenderer {
    private static final Vector3f NULL_VECTOR = new Vector3f();
    protected final SpaceRegion region;
    protected final ArrayList<SpaceObjectRenderer<?>> children = new ArrayList();
    protected final ArrayList<GravityLenseRenderer<?>> lensingRenderers = new ArrayList();
    protected final ArrayList<StarFieldRenderer<?>> starFieldRenderers = new ArrayList();
    protected final ArrayList<ConstellationRenderer<?>> constellationRenderers = new ArrayList();
    private boolean isSetUp = false;

    public SpaceRegionRenderer(SpaceRegion region) {
        this.region = region;
    }

    public SpaceRegion.RegionPos getRegionPos() {
        return this.region.getRegionPos();
    }

    public ArrayList<SpaceObjectRenderer<?>> getChildren() {
        return this.children;
    }

    public boolean addChild(SpaceObjectRenderer<?> child) {
        if (!this.region.addChild((SpaceObject)child.renderedObject())) {
            return false;
        }
        this.children.add(child);
        return true;
    }

    public void setupRegion() {
        for (SpaceObjectRenderer<?> child : this.children) {
            this.setupLensingAndStarFields(child);
        }
        this.isSetUp = true;
    }

    public void setupLensingAndStarFields(SpaceObjectRenderer<?> renderer) {
        ConstellationRenderer constellation;
        if (renderer instanceof StarFieldRenderer) {
            StarFieldRenderer starField = (StarFieldRenderer)renderer;
            this.starFieldRenderers.add(starField);
        } else if (renderer instanceof ConstellationRenderer && (constellation = (ConstellationRenderer)renderer).shouldRender()) {
            this.constellationRenderers.add(constellation);
        } else if (renderer instanceof GravityLenseRenderer) {
            GravityLenseRenderer lense = (GravityLenseRenderer)renderer;
            this.lensingRenderers.add(lense);
        }
        for (SpaceObjectRenderer<?> child : renderer.children()) {
            this.setupLensingAndStarFields(child);
        }
    }

    public void renderDustClouds(ViewCenter viewCenter, ClientLevel level, Camera camera, float partialTicks, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, Runnable setupFog, float brightness) {
        for (StarFieldRenderer<?> starField : this.starFieldRenderers) {
            starField.renderDustClouds(viewCenter, level, partialTicks, modelViewMatrix, camera, projectionMatrix, setupFog, brightness);
        }
    }

    public void render(ViewCenter viewCenter, SpaceObjectRenderer masterParent, ClientLevel level, Camera camera, float partialTicks, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog, Tesselator tesselator) {
        if (!this.isSetUp) {
            this.setupRegion();
        }
        for (SpaceObjectRenderer<?> spaceObject : this.children) {
            if (spaceObject == masterParent) continue;
            spaceObject.render(viewCenter, level, partialTicks, modelViewMatrix, camera, projectionMatrix, isFoggy, setupFog, tesselator, NULL_VECTOR, new AxisRotation());
        }
    }

    public void setBestLensing() {
        if (!GeneralConfig.gravitational_lensing.get()) {
            SpaceRenderer.lensingIntensity = 0.0f;
            SpaceRenderer.lensingMatrixInv = SpaceRenderer.IDENTITY_MATRIX;
            SpaceRenderer.lensingMatrix = SpaceRenderer.IDENTITY_MATRIX;
        } else {
            for (GravityLenseRenderer<?> gravityLense : this.lensingRenderers) {
                if (!(gravityLense.lensingIntensity() > SpaceRenderer.lensingIntensity)) continue;
                gravityLense.setupLensing();
            }
        }
    }

    public void setupSynodicOrbits() {
        for (SpaceObjectRenderer<?> spaceObject : this.children) {
            if (!(spaceObject instanceof OrbitingObjectRenderer)) continue;
            OrbitingObjectRenderer orbitingObject = (OrbitingObjectRenderer)spaceObject;
            orbitingObject.setupSynodicOrbit(null);
        }
    }

    public void resetStarFields() {
        for (StarFieldRenderer<?> starField : this.starFieldRenderers) {
            starField.reset();
        }
    }

    public void resetConstellations() {
        for (ConstellationRenderer<?> constellation : this.constellationRenderers) {
            constellation.reset();
        }
    }
}

