/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.stellarview.client.render.level.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class StellarViewSkyEffects {
    public static VertexBuffer createDarkSky() {
        VertexBuffer darkBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        MeshData mesh = StellarViewSkyEffects.buildSkyDisc(bufferbuilder, -16.0f);
        darkBuffer.bind();
        darkBuffer.upload(mesh);
        VertexBuffer.unbind();
        return darkBuffer;
    }

    public static VertexBuffer createLightSky() {
        VertexBuffer skyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        MeshData mesh = StellarViewSkyEffects.buildSkyDisc(bufferbuilder, 16.0f);
        skyBuffer.bind();
        skyBuffer.upload(mesh);
        VertexBuffer.unbind();
        return skyBuffer;
    }

    public static MeshData buildSkyDisc(BufferBuilder builder, float scale) {
        float baseRadius = 512.0f;
        float invertibleBaseRadius = Math.signum(scale) * baseRadius;
        RenderSystem.setShader(GameRenderer::getPositionShader);
        builder.addVertex(0.0f, scale, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            float radians = (float)Math.toRadians(i);
            builder.addVertex(invertibleBaseRadius * Mth.cos((float)radians), scale, baseRadius * Mth.sin((float)radians));
        }
        return builder.build();
    }

    public static void renderSunrise(ClientLevel level, float partialTicks, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, Tesselator tesselator) {
        float[] sunriseColor = level.effects().getSunriseColor(level.getTimeOfDay(partialTicks), partialTicks);
        if (sunriseColor != null) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f transformedModelView = new Matrix4f((Matrix4fc)modelViewMatrix);
            transformedModelView.rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            float sunAngle = Mth.sin((float)level.getSunAngle(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            transformedModelView.rotate((Quaternionfc)Axis.ZP.rotationDegrees(sunAngle));
            transformedModelView.rotate((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
            float sunriseR = sunriseColor[0];
            float sunriseG = sunriseColor[1];
            float sunriseB = sunriseColor[2];
            float sunriseA = sunriseColor[2];
            Matrix4f sunriseMatrix = transformedModelView;
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            bufferbuilder.addVertex(sunriseMatrix, 0.0f, 100.0f, 0.0f).setColor(sunriseR, sunriseG, sunriseB, sunriseA);
            for (int i = 0; i <= 16; ++i) {
                float rotation = (float)i * ((float)Math.PI * 2) / 16.0f;
                float x = Mth.sin((float)rotation);
                float y = Mth.cos((float)rotation);
                bufferbuilder.addVertex(sunriseMatrix, x * 120.0f, y * 120.0f, -y * 40.0f * sunriseA).setColor(sunriseR, sunriseG, sunriseB, 0.0f);
            }
            BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
        }
    }

    public static void renderSky(Minecraft minecraft, VertexBuffer skyBuffer, ClientLevel level, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, ShaderInstance shaderinstance) {
        skyBuffer.bind();
        skyBuffer.drawWithShader(stack.last().pose(), projectionMatrix, shaderinstance);
    }

    public static void renderDark(Minecraft minecraft, VertexBuffer darkBuffer, ClientLevel level, float partialTicks, PoseStack stack, Matrix4f projectionMatrix, ShaderInstance shaderinstance, Vec3 skyColor) {
        float skyX = (float)skyColor.x;
        float skyY = (float)skyColor.y;
        float skyZ = (float)skyColor.z;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double height = minecraft.player.getEyePosition((float)partialTicks).y - level.getLevelData().getHorizonHeight((LevelHeightAccessor)level);
        if (height < 0.0) {
            stack.pushPose();
            stack.translate(0.0f, 12.0f, 0.0f);
            darkBuffer.bind();
            darkBuffer.drawWithShader(stack.last().pose(), projectionMatrix, shaderinstance);
            VertexBuffer.unbind();
            stack.popPose();
        }
        if (level.effects().hasGround()) {
            RenderSystem.setShaderColor((float)(skyX * 0.2f + 0.04f), (float)(skyY * 0.2f + 0.04f), (float)(skyZ * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
        }
    }
}

